/* vmeget.c */
/* Created by Enomoto Sanshiro on 17 July 2000. */
/* Last updated by Enomoto Sanshiro on 17 July 2000. */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include "vmedrv.h"


#define DEV_FILE "/dev/vmedrv32d32"
typedef unsigned word_t;


int main(int argc, char** argv)
{
    int fd;
    unsigned address;
    word_t word;

    if (
	(argc < 2) ||
	(sscanf(argv[1], "%x", &address) != 1)
    ){
        fprintf(stderr, "Usage: %s ADDRESS\n", argv[0]);
        fprintf(stderr, "  ex) %s 0x02000000\n", argv[0]);
	exit(EXIT_FAILURE);
    }

    if ((fd = open(DEV_FILE, O_RDWR)) == -1) {
        fprintf(stderr, "ERROR: %s: open(): %s\n", argv[0], strerror(errno));
	exit(EXIT_FAILURE);
    }
    
    if (lseek(fd, address, SEEK_SET) == -1) {
        fprintf(stderr, "ERROR: %s: lseek(): %s\n", argv[0], strerror(errno));
	exit(EXIT_FAILURE);
    }

    if (read(fd, &word, sizeof(word_t)) == -1) {
        fprintf(stderr, "ERROR: %s: read(): %s\n", argv[0], strerror(errno));
	exit(EXIT_FAILURE);
    }

    printf("0x%08x\n", word);

    close(fd);

    return 0;
}
