/* K2917.kts */
/* Created by Enomoto Sanshiro on 7 July 2003. */
/* Last updated by Enomoto Sanshiro on 7 July 2003. */


datasource K2917
{
    int address = 0xff00;
    int irq = 3;
    int vector = 0xff33;

    VmeCrate crate;
    VmeController controller("SBS-620");
    VmeModule k2917("Kinetic-2917", "fadc");
    crate.installController(controller);

    crate.installModule(k2917, address, irq, vector);   // Interrupt
    //crate.installModule(k2917, address);              // Loop

    int c = 1, n, f, a, data;

    on run_begin {
	// initialize //
	k2917.executeSingleTransfer(c, n = 30, f = 17, a = 0, 0x000001);

	// enable ServiceRequest //
	k2917.executeSingleTransfer(c, n = 30, f = 17, a = 0, 0x000100);

	// enable LAM //
	k2917.executeSingleTransfer(c, n = 30, f = 17, a = 13, 0x00ffffff);

	// build command list //
	k2917.setCommandMemoryAddress(0);
	k2917.loadQStopBlockTransferCommand(c, n = 10, f = 0, a = 0);
	k2917.loadSingleTransferCommand(c, n = 10, f = 9, a = 0);
	k2917.loadSingleTransferCommand(c, n = 10, f = 26, a = 0);
	k2917.loadHaltCommand();
    }

    on trigger(k2917) {
	// select command list //
	k2917.setCommandMemoryAddress(0);

	// read data as "indexed" (array of integers) //
        // Address value (#0) is used only to fill the "address" field 
	// of data packets.
        k2917.sequentialRead(#0);

	// read data as "block" (unstructured) //
	// DataAnalyzer/DataProcessor is necessary to decode the data packets.
        /* k2917.blockRead(); */
    }
}
