/* Trial04-DataAnalyzer.cc */


#include <cstdlib>
#include <iostream>
#include <string>
#include "KinokoKdfReader.hh"
#include "KinokoSectionDataAnalyzer.hh"

using namespace std;


static const char* DataSourceName = "";
static const char* SectionName = "adc";
static const int NumberOfDataElements = 4;


class TMyDataAnalyzer: public TKinokoSectionDataAnalyzer {
  public:
    TMyDataAnalyzer(TKinokoKdfReader* KdfReader);
    virtual ~TMyDataAnalyzer();
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
    virtual bool GetData(const int*& Data);
  protected:
    TKinokoKdfReader* _KdfReader;
    int _DataBuffer[NumberOfDataElements];
    bool _IsDataAvailable;
};



TMyDataAnalyzer::TMyDataAnalyzer(TKinokoKdfReader* KdfReader)
: TKinokoSectionDataAnalyzer(SectionName)
{
    _KdfReader = KdfReader;
    _IsDataAvailable = false;
}

TMyDataAnalyzer::~TMyDataAnalyzer()
{
}

int TMyDataAnalyzer::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    int Address, Data;
    while (SectionData->GetNext(Address, Data)) {
	if (Address < NumberOfDataElements) {
	    _DataBuffer[Address] = Data;
	}
    }
    
    _IsDataAvailable = true;

    return 1;
}

bool TMyDataAnalyzer::GetData(const int*& Data)
{
    while (! _IsDataAvailable) {
	if (! _KdfReader->ProcessNext()) {
	    return false;
	}
    }

    Data = _DataBuffer;
    _IsDataAvailable = false;

    return true;
}



int main(int argc, char** argv)
{
    if (argc < 2) {
	cerr << "Usage: " << argv[0] << " DataFileName" << endl;
        return EXIT_FAILURE;
    }
    string DataFileName = argv[1];

    TKinokoKdfReader* KdfReader = new TKinokoKdfReader(DataFileName);
    TMyDataAnalyzer* Analyzer = new TMyDataAnalyzer(KdfReader);
    
    try {
	KdfReader->RegisterAnalyzer(DataSourceName, Analyzer);

	const int* Data;
	while (Analyzer->GetData(Data)) {
	    for (int i = 0; i < NumberOfDataElements; i++) {
		cout << i << " " << Data[i] << endl;
	    }
	    cout << endl;
	}
    }
    catch (TKinokoException& e) {
	cerr << "ERROR: " << e << endl;
        return EXIT_FAILURE;
    }

    delete Analyzer;
    delete KdfReader;

    return 0;
}
