/* VmeCamacBridge.kts */
/* Created by Enomoto Sanshiro on 5 July 2003. */
/* Last updated by Enomoto Sanshiro on 5 July 2003. */


datasource VmeCamacBridge
{
    int bridge_address = 0xff00;
    int bridge_irq = 3;
    int bridge_vector = 0xff33;

    int adc_station = 8;
    int adc_channels = #0..#3;

    VmeCrate vme_crate;
    VmeController vme_controller("SBS-620");
    VmeCamacBridge bridge("Kinetic-2917");
    vme_crate.installController(vme_controller);

    vme_crate.installModule(bridge, bridge_address, bridge_irq, bridge_vector);
    //vme_crate.installModule(bridge, bridge_address);

    CamacCrate camac_crate;
    CamacModule adc("Rinei-RPC022");
    camac_crate.installController(bridge);
    camac_crate.installModule(adc, adc_station);

    on trigger(adc) {
	adc.read(adc_channels);
	adc.clear();
    }
}
