<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">


<xsl:template match="/">
<html>
  <head>
    <title>SmallKinoko Run Summary</title>
  </head>
  <body bgcolor="white">
    <xsl:apply-templates/>
  </body>
  </html>
</xsl:template>


<xsl:template match="report-message">
  <div align="center">
    <h1>SmallKinoko Run Summary</h1>
    <h3>Run <xsl:value-of select="run-name"/></h3>
  </div>

  Date: <b><xsl:value-of select="date"/></b><br/>
  User Name: <b><xsl:value-of select="user-name"/></b><br/>
  Comment: <b><xsl:value-of select="comment"/></b><br/>

  <p/>
  <div align="right">
  <font color="black"><b>KiNOKO</b></font>
  </div>
  <hr size="1" noshade="1"/>

  <h3>Run Summary</h3>

  Start Time: <xsl:value-of select="start-time"/><br/>
  Stop Time: <xsl:value-of select="stop-time"/><br/>
  Time: <xsl:value-of select="running-time"/> sec<br/>
  <p/>
  Errors: <xsl:value-of select="event-count[@type='error']"/><br/>
  Warnings: <xsl:value-of select="event-count[@type='warning']"/><br/>
  Error Message: <font color="red"><xsl:value-of select="error-message"/></font><br/>
  <p/>
  Data File: <xsl:value-of select="data-file"/><br/>
  Log File: <a><xsl:attribute name="href"><xsl:value-of select="log-file"/></xsl:attribute><xsl:value-of select="log-file"/></a><br/>

  Viewer Images: |
  <xsl:for-each select="picture">
      <a><xsl:attribute name="href"><xsl:value-of select="."/></xsl:attribute>
      <xsl:value-of select="@name"/></a> |
  </xsl:for-each>

  <p/>
  <h3>Configurations</h3>
  Readout Scripts:
  <blockquote>
  <table>
  <xsl:for-each select="script[@type='kts']">
    <tr>
      <td><xsl:value-of select="@target"/></td>
      <td><xsl:value-of select="."/></td>
    </tr>
  </xsl:for-each>
  </table>
  </blockquote>

  View Scripts:
  <blockquote>
  <table>
  <xsl:for-each select="script[@type='kvs']">
    <tr>
      <td><xsl:value-of select="@target"/></td>
      <td><xsl:value-of select="."/></td>
    </tr>
  </xsl:for-each>
  </table>
  </blockquote>

  Buffer Size: <xsl:value-of select="buffer-size"/><br/>
  <p/>
</xsl:template>


</xsl:stylesheet>
