/* socketbench.cc */
/* SOCKET benchmark program */
/* Created by Enomoto Sanshiro on 13 October 1998. */
/* Last updated by Enomoto Sanshiro on 13 January 1999. */


#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include "MushNetworkSocket.hh"
#include "MushTimer.hh"
#include "MushMisc.hh"
#include "KinokoDefs.hh"

using namespace std;


const static long TotalSize = 512 * 1024;
const static size_t BufferSize = 256 * 1024;
static char Buffer[BufferSize];


void Write(TMushSocket *Socket) throw(TKinokoException)
{
    TMushDateTime StartTime, StopTime;

    for (unsigned long PacketSize = 1024; PacketSize < BufferSize; PacketSize += 2 * 1024) {
	long NumberOfPackets = TotalSize / PacketSize;
	double TransferSize = PacketSize * NumberOfPackets;

	StartTime.Update();
	for (int i = 0; i < NumberOfPackets; i++) {
	    Socket->Send(Buffer, PacketSize);
	}
	StopTime.Update();
	
	double TransferTime = (
            (StopTime.AsLong() - StartTime.AsLong()) + 
            (StopTime.USec() - StartTime.USec()) * 1e-6
        );
	double Speed = TransferSize / TransferTime;
	double PacketTime = TransferTime / NumberOfPackets;
	
#if 0
	cerr << "total size = " << (TransferSize / 1024 / 1024) << " [MB]" << endl;
	cerr << "# of packets = " << NumberOfPackets << endl;
	cerr << "packet size = " << (PacketSize / 1024) << " [kB]" << endl;
	cerr << "packet time = " << (PacketTime * 1e+3) << " [msec]" << endl;
	cerr << "total time = " << TotalTime << " [sec]" << endl;
	cerr << "speed = " << (Speed / 1024.0 / 1024.0) << " [MB/sec]" << endl;
	cerr << endl;
#else
	cerr << '.' << flush;
#endif

	cout << (PacketSize / 1024) << "\t";
        cout << (PacketTime * 1e+3) << "\t";
	cout << TransferTime << "\t";
        cout << (Speed / 1024.0 / 1024.0)  << "\t";
	cout << endl; 
    }

    cerr << endl;
}

void Read(TMushSocket *Socket) throw(TKinokoException)
{
    while (Socket->Receive(Buffer, BufferSize)) {
	;
    }
}


int main(int argc, char **argv)
{
    if (argc < 2) {
	cerr << "Usage: socketbench HostName PortNumber" << endl;
	return -1;
    }

    char *HostName = argv[1];
    int PortNumber = atol(argv[2]);
    TMushNetworkSocket *Socket = 0;

    try {
	try {
	    (Socket = new TMushClientNetworkSocket(HostName, PortNumber))->Open();
	}
	catch (TSystemCallException &e) {
	    (Socket = new TMushServerNetworkSocket(PortNumber))->Open();
	}
    }
    catch (TSystemCallException &e) {
        cerr << e << endl;
    }

    try {
	if (Socket->IsServer()) {
	    cerr << "reading " << Socket->RemoteHostName() << "...";
	    Read(Socket);
	    cerr << "done." << endl;
	}
	else {
	    Write(Socket);
	}
    }
    catch (TKinokoException e) {
	cerr << e << endl;
    }

    Socket->Close();
    delete Socket;

    return 0;
}
