/* Kasp2dHistogram.cc */
/* Created by Enomoto Sanshiro on 13 January 2001. */
/* Last updated by Enomoto Sanshiro on 29 June 2002. */


#include <string>
#include "KaspHistogram.hh"
#include "Kasp2dHistogram.hh"


using namespace std;


TKasp2dHistogram::TKasp2dHistogram(const string& Title, const TKaspHistogramScale& XScale, const TKaspHistogramScale& YScale)
: TKaspObject(Title), _XScale(XScale), _YScale(YScale)
{
    _NumberOfXBins = _XScale.NumberOfBins();
    _NumberOfYBins = _YScale.NumberOfBins();

    _Storage = new double[_NumberOfXBins * _NumberOfYBins];

    Clear();
}

TKasp2dHistogram::~TKasp2dHistogram()
{
    delete[] _Storage;
}

void TKasp2dHistogram::Clear(void)
{
    _PeakCounts = 0;
    _NumberOfEntries = 0;

    for (int i = 0; i < _NumberOfXBins * _NumberOfYBins; i++) {
	_Storage[i] = 0;
    }
}

bool TKasp2dHistogram::HasData(void)
{
    return (_NumberOfEntries > 0);
}
