/* KaspHistogram.cc */
/* Created by Enomoto Sanshiro on 29 October 1999. */
/* Last updated by Enomoto Sanshiro on 29 June 2002. */


#include <string>
#include <cmath>
#include "KaspHistogram.hh"

using namespace std;

#define sqr(x) ((x) * (x))


TKaspHistogram::TKaspHistogram(const string& Title, const TKaspHistogramScale& Scale)
: TKaspObject(Title), _Scale(Scale)
{
    _Storage = new double[_Scale.NumberOfBins()];
    Clear();
}

TKaspHistogram::TKaspHistogram(const string& Title, int NumberOfBins, double Min, double Max)
: TKaspObject(Title), _Scale(TKaspHistogramScale(NumberOfBins, Min, Max))
{
    _Storage = new double[_Scale.NumberOfBins()];
    Clear();
}

TKaspHistogram::~TKaspHistogram()
{
    delete[] _Storage;
}

void TKaspHistogram::Clear(void)
{
    _OverflowCounts = 0;
    _UnderflowCounts = 0;
    _NumberOfEntries = 0;

    _Sum = 0;
    _SumOfWeight = 0;
    _SumOfSquared = 0;

    _PeakCounts = 0;
    _PeakBinIndex = 0;

    for (int i = 0; i < _Scale.NumberOfBins(); i++) {
	_Storage[i] = 0;
    }
}

bool TKaspHistogram::HasData(void)
{
    return (_NumberOfEntries > 0);
}



TKaspHistogramScale::TKaspHistogramScale(int NumberOfBins, double Min, double Max)
{
    _NumberOfBins = NumberOfBins;
    _Min = Min;
    _Max = Max;

    _BinWidth = (_Max - _Min) / _NumberOfBins;
}

TKaspHistogramScale::~TKaspHistogramScale()
{
}

string TKaspHistogramScale::Title(void) const
{
    return _Title;
}

void TKaspHistogramScale::SetTitle(const string& Title)
{
    _Title = Title;
}
