/* KaspMap.hh */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 29 June 2002. */


#ifndef __KaspMap_hh__
#define __KaspMap_hh__


#include <string>
#include <vector>
#include "KaspObject.hh"


class TKaspMap: public TKaspObject {
  public:
    TKaspMap(const std::string& Title, int InitialStorageCapacity = 1024);
    ~TKaspMap();
    void Clear(void);
    bool HasData(void);
  public:
    inline void Fill(long Address, double Data);
    inline long NumberOfPoints(void) const;
    inline long AddressOf(int Index) const;
    inline double ValueOf(int Index) const;
  protected:
    std::vector<std::pair<long, double> > _Storage;
    long _NumberOfPoints;
};


inline void TKaspMap::Fill(long Address, double Data)
{
    if (_NumberOfPoints < (int) _Storage.size()) {
	_Storage[_NumberOfPoints] = std::make_pair(Address, Data);
    }
    else {
	_Storage.push_back(std::make_pair(Address, Data));
    }
    _NumberOfPoints++;
}

inline long TKaspMap::AddressOf(int Index) const
{
    if (Index >= _NumberOfPoints) {
	return 0;
    }

    return _Storage[Index].first;
}

inline double TKaspMap::ValueOf(int Index) const
{
    if (Index >= _NumberOfPoints) {
	return 0;
    }

    return _Storage[Index].second;
}

inline long TKaspMap::NumberOfPoints(void) const
{
    return _NumberOfPoints;
}

#endif
