/* KaspNtuple.cc */
/* Created by Enomoto Sanshiro on 10 August 2002. */
/* Last updated by Enomoto Sanshiro on 10 August 2002. */


#include <strstream>
#include <iomanip>
#include <string>
#include "KaspNtuple.hh"

using namespace std;


TKaspNtuple::TKaspNtuple(const string& Title, unsigned NumberOfColumns)
: TKaspObject(Title)
{
    _NumberOfColumns = NumberOfColumns;

    _NumberOfBlocks = 0;
    _BlockRows = 256;

    char ColumnName[32];
    for (unsigned ColumnIndex = 0; ColumnIndex < _NumberOfColumns; ColumnIndex++) {
	ostrstream ColumnNameStream(ColumnName, sizeof(ColumnName));
	ColumnNameStream << "Column" << setfill('0') << setw(2) << ColumnIndex;
	ColumnNameStream << ends;
	SetColumnName(ColumnIndex, ColumnName);
    }

    Clear();
}

TKaspNtuple::~TKaspNtuple()
{
    for (unsigned i = 0; i < _StorageBlockList.size(); i++) {
	delete[] _StorageBlockList[i];
    }
}

void TKaspNtuple::Clear(void)
{
    _NumberOfRows = 0;
}

bool TKaspNtuple::HasData(void)
{
    return (_NumberOfRows > 0);
}

void TKaspNtuple::SetColumnName(unsigned ColumnIndex, const string& ColumnName)
{
    _ColumnIndexNameTable[ColumnIndex] = ColumnName;
    _ColumnNameIndexTable[ColumnName] = ColumnIndex;
}

const string& TKaspNtuple::ColumnNameOf(unsigned ColumnIndex) throw(TKaspException)
{
    if (ColumnIndex >= _NumberOfColumns) {
	throw TKaspException("TKaspNtuple::ColumnNameOf()", "bad column index");
    }

    return _ColumnIndexNameTable[ColumnIndex];
}

unsigned TKaspNtuple::ColumnIndexOf(const string& ColumnName) throw(TKaspException)
{
    if (_ColumnNameIndexTable.count(ColumnName) == 0) {
	throw TKaspException("TKaspNtuple::ColumnIndexOf()", "bad column name");
    }

    return _ColumnNameIndexTable[ColumnName];
}
