/* KaspObject.cc */
/* Created by Enomoto Sanshiro on 11 November 2002. */
/* Last updated by Enomoto Sanshiro on 11 November 2002. */


#include <string>
#include <vector>
#include <map>
#include "KaspObject.hh"

using namespace std;


TKaspObject::TKaspObject(const std::string& Title)
{
    _Title = Title;
}

TKaspObject::~TKaspObject()
{
}

const std::string& TKaspObject::Title(void) const
{
    return _Title;
}

void TKaspObject::SetTitle(const std::string& Title)
{
    _Title = Title;
}

void TKaspObject::AddProperty(const std::string& Name, const std::string& Value)
{
    _PropertyList.push_back(make_pair(Name, Value));
    _PropertyTable[Name] = Value;
}

unsigned TKaspObject::NumberOfProperties(void)
{
    return _PropertyList.size();
}

string TKaspObject::PropertyNameOf(unsigned Index)
{
    return _PropertyList[Index].first;
}

string TKaspObject::PropertyValueOf(unsigned Index)
{
    return _PropertyList[Index].second;
}

string TKaspObject::PropertyValueOf(const std::string& Name)
{
    return _PropertyTable[Name];
}
