/* KaspObject.hh */
/* Created by Enomoto Sanshiro on 11 November 2002. */
/* Last updated by Enomoto Sanshiro on 11 November 2002. */


#ifndef __KaspObject_hh__
#define __KaspObject_hh__


#include <string>
#include <vector>
#include <map>
#include "KaspDefs.hh"


class TKaspObject {
  public:
    TKaspObject(const std::string& Title);
    virtual ~TKaspObject();
    virtual const std::string& Title(void) const;
    virtual void SetTitle(const std::string& Title);
    virtual void AddProperty(const std::string& Name, const std::string& Value);
    virtual unsigned NumberOfProperties(void);
    virtual std::string PropertyNameOf(unsigned Index);
    virtual std::string PropertyValueOf(unsigned Index);
    virtual std::string PropertyValueOf(const std::string& Name);
  protected:
    std::string _Title;
    std::vector<std::pair<std::string, std::string> > _PropertyList;
    std::map<std::string, std::string> _PropertyTable;
};


#endif
