/* KaspPlainTextRepository.hh */
/* Created by Enomoto Sanshiro on 26 June 2002. */
/* Last updated by Enomoto Sanshiro on 26 June 2002. */


#ifndef __KaspPlainTextRepository_hh__
#define __KaspPlainTextRepository_hh__


#include <fstream>
#include <string>
#include <vector>
#include <map>
#include "KaspConfig.hh"
#include "KaspRepository.hh"


class TKaspPlainTextRepository: public TKaspRepository {
  public:
    TKaspPlainTextRepository(const std::string& RepositoryName);
    TKaspPlainTextRepository(void);
    virtual ~TKaspPlainTextRepository();
    virtual void SaveNtuple(const std::string& Name, TKaspNtuple* Ntuple) throw(TKaspException);
    virtual void SaveGraph(const std::string& Name, TKaspGraph* Graph) throw(TKaspException);
    virtual void SaveHistogram(const std::string& Name, TKaspHistogram* Histogram) throw(TKaspException);
    virtual void Save2dHistogram(const std::string& Name, TKasp2dHistogram* Histogram) throw(TKaspException);
    virtual void SaveHistory(const std::string& Name, TKaspHistory* History) throw(TKaspException);
    virtual void SaveWave(const std::string& Name, TKaspWave* Wave) throw(TKaspException);
    virtual void SaveMap(const std::string& Name, TKaspMap* Map) throw(TKaspException);
    virtual void SaveTabular(const std::string& Name, TKaspTabular* Tabular) throw(TKaspException);
    virtual TKaspNtuple* LoadNtuple(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKaspGraph* LoadGraph(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKaspHistogram* LoadHistogram(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKasp2dHistogram* Load2dHistogram(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKaspHistory* LoadHistory(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKaspWave* LoadWave(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKaspMap* LoadMap(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKaspTabular* LoadTabular(const std::string& Name, int Revision = -1) throw(TKaspException);
  protected:
    virtual std::string FileNameOf(const std::string& ObjectName, int Revision = -1);
    virtual std::ofstream* OpenToWrite(const std::string& ObjectName, int Revision = -1) throw(TKaspException);
    virtual std::ifstream* OpenToRead(const std::string& ObjectName, int Revision = -1) throw(TKaspException);
  protected:
    std::string _RepositoryName;
    bool _IsRepositoryCreated;
    std::map<std::string, int> _RevisionTable;
};


class TKaspPlainTextRepositoryHeader {
  public:
    TKaspPlainTextRepositoryHeader(void);
    virtual ~TKaspPlainTextRepositoryHeader(void);
    virtual unsigned NumberOfItems();
    virtual bool ReadLine(const std::string& HeaderItemLine);
    virtual std::string ItemNameOf(unsigned ItemIndex);
    virtual std::string ItemValueOf(unsigned ItemIndex);
    virtual std::string ItemValueOf(const std::string& ItemName);
    virtual std::vector<std::string> ItemValueListOf(unsigned ItemIndex);
    virtual std::vector<std::string> ItemValueListOf(const std::string& ItemName);
    static std::vector<std::string> SplitValue(const std::string& Value, const std::string& SeparatorSet = ", ");
  protected:
    std::vector<std::pair<std::string, std::string> > _ItemList;
    std::map<std::string, std::string> _ItemTable;
};


#endif
