/* KaspRepository.hh */
/* Created by Enomoto Sanshiro on 26 June 2002. */
/* Last updated by Enomoto Sanshiro on 26 June 2002. */


#ifndef __KaspRepository_hh__
#define __KaspRepository_hh__


#include <string>
#include "KaspDefs.hh"


class TKaspNtuple;
class TKaspGraph;
class TKaspHistogram;
class TKasp2dHistogram;
class TKaspHistory;
class TKaspWave;
class TKaspMap;
class TKaspTabular;


class TKaspRepository {
  public:
    TKaspRepository(void) {}
    virtual ~TKaspRepository() {}
    virtual void SaveNtuple(const std::string& Name, TKaspNtuple* Ntuple) throw(TKaspException) = 0;
    virtual void SaveGraph(const std::string& Name, TKaspGraph* Graph) throw(TKaspException) = 0;
    virtual void SaveHistogram(const std::string& Name, TKaspHistogram* Histogram) throw(TKaspException) = 0;
    virtual void Save2dHistogram(const std::string& Name, TKasp2dHistogram* Histogram) throw(TKaspException) = 0;
    virtual void SaveHistory(const std::string& Name, TKaspHistory* History) throw(TKaspException) = 0;
    virtual void SaveWave(const std::string& Name, TKaspWave* Wave) throw(TKaspException) = 0;
    virtual void SaveMap(const std::string& Name, TKaspMap* Map) throw(TKaspException) = 0;
    virtual void SaveTabular(const std::string& Name, TKaspTabular* Tabular) throw(TKaspException) = 0;
    virtual TKaspNtuple* LoadNtuple(const std::string& Name, int Revision = -1) throw(TKaspException) = 0;
    virtual TKaspGraph* LoadGraph(const std::string& Name, int Revision = -1) throw(TKaspException) = 0;
    virtual TKaspHistogram* LoadHistogram(const std::string& Name, int Revision = -1) throw(TKaspException) = 0;
    virtual TKasp2dHistogram* Load2dHistogram(const std::string& Name, int Revision = -1) throw(TKaspException) = 0;
    virtual TKaspHistory* LoadHistory(const std::string& Name, int Revision = -1) throw(TKaspException) = 0;
    virtual TKaspWave* LoadWave(const std::string& Name, int Revision = -1) throw(TKaspException) = 0;
    virtual TKaspMap* LoadMap(const std::string& Name, int Revision = -1) throw(TKaspException) = 0;
    virtual TKaspTabular* LoadTabular(const std::string& Name, int Revision = -1) throw(TKaspException) = 0;
};


#endif
