/* KaspRepository.hh */
/* Created by Enomoto Sanshiro on 26 June 2002. */
/* Last updated by Enomoto Sanshiro on 26 June 2002. */


#ifndef __KaspRepositoryFactory_hh__
#define __KaspRepositoryFactory_hh__


#include <string>
#include "KaspRepository.hh"


class TKaspRepositoryFactory {
  protected:
    TKaspRepositoryFactory(void);
  public:
    virtual ~TKaspRepositoryFactory();
    static TKaspRepositoryFactory* GetInstance(const std::string& Type);
    virtual TKaspRepository* CreateRepository(const std::string& Name) = 0;
  private:
    static TKaspRepositoryFactory* _PlainTextRepositoryFactory;
    static TKaspRepositoryFactory* _XmlRepositoryFactory;
    static TKaspRepositoryFactory* _RootRepositoryFactory;
};


class TKaspPlainTextRepositoryFactory: public TKaspRepositoryFactory {
  public:
    TKaspPlainTextRepositoryFactory(void);
    virtual ~TKaspPlainTextRepositoryFactory();
    virtual TKaspRepository* CreateRepository(const std::string& Name);
};


class TKaspXmlRepositoryFactory: public TKaspRepositoryFactory {
  public:
    TKaspXmlRepositoryFactory(void);
    virtual ~TKaspXmlRepositoryFactory();
    virtual TKaspRepository* CreateRepository(const std::string& Name);
};


class TKaspRootRepositoryFactory: public TKaspRepositoryFactory {
  public:
    TKaspRootRepositoryFactory(void);
    virtual ~TKaspRootRepositoryFactory();
    virtual TKaspRepository* CreateRepository(const std::string& Name);
};


#endif
