/* KaspWave.cc */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 29 June 2002. */


#include <string>
#include <algorithm>
#include "KaspWave.hh"


using namespace std;


TKaspWave::TKaspWave(const string& Title, int InitialStorageCapacity)
: TKaspObject(Title)
{
    _Storage.reserve(InitialStorageCapacity);
    _DataCountList.reserve(InitialStorageCapacity);

    Clear();
}

TKaspWave::~TKaspWave()
{
}

void TKaspWave::Clear(void)
{
    _NumberOfPoints = 0;

    fill(_Storage.begin(), _Storage.end(), 0);
    fill(_DataCountList.begin(), _DataCountList.end(), 0);
}

bool TKaspWave::HasData(void)
{
    return (_NumberOfPoints > 0);
}
