/* KaspXmlRepository.hh */
/* Created by Enomoto Sanshiro on 26 June 2002. */
/* Last updated by Enomoto Sanshiro on 26 June 2002. */


#ifndef __KaspXmlRepository_hh__
#define __KaspXmlRepository_hh__


#include <string>
#include <fstream>
#include "KaspConfig.hh"
#include "KaspRepository.hh"


class TKaspXmlRepository: public TKaspRepository {
  public:
    TKaspXmlRepository(const std::string& FileName);
    virtual ~TKaspXmlRepository();
    virtual void SaveNtuple(const std::string& Name, TKaspNtuple* Ntuple) throw(TKaspException);
    virtual void SaveGraph(const std::string& Name, TKaspGraph* Graph) throw(TKaspException);
    virtual void SaveHistogram(const std::string& Name, TKaspHistogram* Histogram) throw(TKaspException);
    virtual void Save2dHistogram(const std::string& Name, TKasp2dHistogram* Histogram) throw(TKaspException);
    virtual void SaveHistory(const std::string& Name, TKaspHistory* History) throw(TKaspException);
    virtual void SaveWave(const std::string& Name, TKaspWave* Wave) throw(TKaspException);
    virtual void SaveMap(const std::string& Name, TKaspMap* Map) throw(TKaspException);
    virtual void SaveTabular(const std::string& Name, TKaspTabular* Tabular) throw(TKaspException);
    virtual TKaspNtuple* LoadNtuple(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKaspGraph* LoadGraph(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKaspHistogram* LoadHistogram(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKasp2dHistogram* Load2dHistogram(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKaspHistory* LoadHistory(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKaspWave* LoadWave(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKaspMap* LoadMap(const std::string& Name, int Revision = -1) throw(TKaspException);
    virtual TKaspTabular* LoadTabular(const std::string& Name, int Revision = -1) throw(TKaspException);
  protected:
    virtual void OpenToWrite(void) throw(TKaspException);
    virtual void OpenToRead(void) throw(TKaspException);
    virtual void Close(void);
  protected:
    std::ofstream* _OutputFile;
    std::ifstream* _InputFile;
    std::string _FileName;
};


#endif
