/* histogram-test.cc */
/* Created by Enomoto Sanshiro on 11 August 2002. */
/* Last updated by Enomoto Sanshiro on 23 December 2002. */


#include <iostream>
#include <cstdlib>
#include <cmath>
#include <time.h>
#include "KaspHistogram.hh"
#include "KaspPlainTextRepository.hh"
#include "KaspXmlRepository.hh"
#include "KaspRootRepository.hh"

using namespace std;


int main(int argc, char** argv)
{
    TKaspHistogram* Histogram = 0;

    if (argc > 1) {
	// loading a histogram from a repository //
	try {
	    TKaspPlainTextRepository Repository(argv[1]);
	    Histogram = Repository.LoadHistogram("test");
	}
	catch (TKaspException &e) {
	    cerr << "ERROR: " << e << endl;
	    return -1;
	}
    }
    else {
	// creating and filling a histogram //
	Histogram = new TKaspHistogram("this is a test", 30, -3, 3);
	srand48(time(NULL));
	double Gauss;
	for (int i = 0; i < 1024; i++) {
	    Gauss = sqrt(-2.0 * log(drand48())) * cos(2 * M_PI * drand48());
	    Histogram->Fill(Gauss);
	}
    }

    // showing a histogram //
    unsigned NumberOfBins = Histogram->Scale().NumberOfBins();
    for (unsigned i = 0; i < NumberOfBins; i++) {
	cout << Histogram->Scale().BinValueOf(i) << " ";
	cout << Histogram->CountsOf(i) << endl;
    }

    // saving a histogram into a repository //
    try {
	TKaspPlainTextRepository Repository("test-histogram");
	//TKaspXmlRepository Repository("test-histogram.xml");
	//TKaspRootRepository Repository("test-histogram.root");

	Repository.SaveHistogram("test", Histogram);
    }
    catch (TKaspException &e) {
	cerr << "ERROR: " << e << endl;
	delete Histogram;
	return -1;
    }

    delete Histogram;

    return 0;
}
