/* KcomComponentAssembler.cc */
/* Created by Enomoto Sanshiro on 27 April 2000. */
/* Last updated by Enomoto Sanshiro on 1 August 2001. */


#include <string>
#include <vector>
#include <map>
#include "MushTimer.hh"
#include "MushMisc.hh"
#include "KorbOrb.hh"
#include "KorbBroker.hh"
#include "KorbCommander.hh"
#include "KorbNamingContext.hh"
#include "KcomManager.hh"
#include "KcomComponentAssembler.hh"

using namespace std;


TKcomDeployment::TKcomDeployment(const string& Name, const string& Type, const string& Host, const string& Control)
{
    _Name = Name;
    _TypeName = Type;
    _HostName = Host;
    _Control = Control;
}

TKcomDeployment::~TKcomDeployment()
{
}

const string& TKcomDeployment::Name(void) const
{
    return _Name;
}

const string& TKcomDeployment::TypeName(void) const
{
    return _TypeName;
}

const string& TKcomDeployment::HostName(void) const
{
    return _HostName;
}

const string& TKcomDeployment::Control(void) const
{
    return _Control;
}

void TKcomDeployment::Dump(ostream& os, const string& Indent) const
{
    string Host = _HostName;
    if (Host.empty()) {
	Host = "localhost";
    }
    
    os << Indent << _Name << ": " << _TypeName << "@" << Host;
    if (! _Control.empty()) {
	os << " (control is '" << _Control << "')";
    }
    os << endl;
}



TKcomComponentAssembler::TKcomComponentAssembler(TKcomManager* Manager, TKorbCommander* Commander, TKorbOrb* Orb)
{
    _Manager = Manager;
    _Commander = Commander;
    _Orb = Orb;
}

TKcomComponentAssembler::~TKcomComponentAssembler()
{
}

void TKcomComponentAssembler::AddComponent(const TKcomDeployment& Deployment)
{
    _DeploymentList.push_back(Deployment);
}

void TKcomComponentAssembler::DeployComponents(void) throw(TKcomException)
{
    for (unsigned i = 0; i < _DeploymentList.size(); i++) {
	string Name = _DeploymentList[i].Name();
	string TypeName = _DeploymentList[i].TypeName();
	string HostName = _DeploymentList[i].HostName();
	string Control = _DeploymentList[i].Control();
	string ProcessName = TypeName + "-kcom";

	int DomainId = _Manager->DomainIdOf(HostName);

	vector<string> ArgumentList;
	ArgumentList.push_back(ProcessName);
	ArgumentList.push_back(Name);
	
	if (! Control.empty()) {
	    ArgumentList.push_back(Control);
	}

	try {
	    _Commander->LaunchProcess(DomainId, ProcessName, ArgumentList);
#if 1
	    cerr << "launching ";
	    _DeploymentList[i].Dump(cerr);
#endif
	}
	catch (TKorbException &e) {
	    throw TKcomException(
		"TKcomLauncher::DeployComponents()",
		"korb exception: " + e.Message()
            );
	}
    }
}

int TKcomComponentAssembler::NumberOfComponents(void) const
{
    return _DeploymentList.size();
}

const TKcomDeployment& TKcomComponentAssembler::operator[] (int Index) const
{
    return _DeploymentList[Index];
}

void TKcomComponentAssembler::Dump(ostream& os) const
{
    for (unsigned int i = 0; i < _DeploymentList.size(); i++) {
	_DeploymentList[i].Dump(os);
    }
}
