/* KcomComponentAssembler.hh */
/* Created by Enomoto Sanshiro on 27 April 2000. */
/* Last updated by Enomoto Sanshiro on 1 August 2001. */


#ifndef __KcomComponentAssembler_hh__
#define __KcomComponentAssembler_hh__


#include <iostream>
#include <string>
#include <vector>
#include "KorbOrb.hh"
#include "KorbCommander.hh"
#include "KcomDefs.hh"

class TKcomManager;


class TKcomDeployment {
  public:
    TKcomDeployment(const std::string& Name, const std::string& Type, const std::string& Host, const std::string& Control);
    virtual ~TKcomDeployment();
    virtual const std::string& Name(void) const;
    virtual const std::string& TypeName(void) const;
    virtual const std::string& HostName(void) const;
    virtual const std::string& Control(void) const;
    virtual void Dump(std::ostream& os, const std::string& Indent = "") const;
  private:
    std::string _Name;
    std::string _TypeName;
    std::string _HostName;
    std::string _Control;
};



class TKcomComponentAssembler {
  public:
    TKcomComponentAssembler(TKcomManager* Manager, TKorbCommander* Commander, TKorbOrb* Orb);
    virtual ~TKcomComponentAssembler();
    virtual void AddComponent(const TKcomDeployment& Deployment);
    virtual void DeployComponents(void) throw(TKcomException);
    virtual int NumberOfComponents(void) const;
    virtual const TKcomDeployment& operator[] (int Index) const;
    virtual void Dump(std::ostream& os) const;
  protected:
    TKcomManager* _Manager;
    TKorbOrb* _Orb;
    TKorbCommander* _Commander;
    std::vector<TKcomDeployment> _DeploymentList;
};


#endif

