/* KcomComponentDescriptor.cc */
/* Created by Enomoto Sanshiro on 30 March 2000. */
/* Last updated by Enomoto Sanshiro on 20 August 2000. */


#include <iostream>
#include <string>
#include <vector>
#include "KorbObjectProxy.hh"
#include "KorbObjectMessenger.hh"
#include "KcomInterfaceDeclaration.hh"
#include "KcomComponentDescriptor.hh"

using namespace std;


TKcomComponentDescriptor::TKcomComponentDescriptor(const string& TypeName)
: TKcomComponentDeclaration(TypeName)
{
}

TKcomComponentDescriptor::~TKcomComponentDescriptor()
{
}

void TKcomComponentDescriptor::RegisterProperty(int PropertyId, const TKcomPropertyDeclaration& Property)
{
    AddProperty(Property);
    _PropertyIdToNameTable[PropertyId] = Property.Name();
}

void TKcomComponentDescriptor::RegisterExportObject(TKorbObjectMessenger* Messenger, const TKcomObjectDeclaration& Object)
{
    AddExportObject(Object);

    _ExportObjectList.push_back(make_pair(Messenger, Object));
}

void TKcomComponentDescriptor::RegisterImportObject(TKorbObjectProxy* Proxy, const TKcomObjectDeclaration& Object)
{
    AddImportObject(Object);

    _ImportObjectList.push_back(make_pair(Proxy, Object));
}

void TKcomComponentDescriptor::RegisterEventSource(int EventId, const TKcomEventDeclaration& Event)
{
    AddEventSource(Event);

    _EventIdToNameTable[EventId] = Event.Name();
    _EventNameToIdTable[Event.Name()] = EventId;
}

void TKcomComponentDescriptor::RegisterEventSlot(int EventId, const TKcomEventDeclaration& Event)
{
    AddEventSlot(Event);

    // To realize virtual call, existing same entry should be overwritten.
    _EventNameToIdTable[Event.Name()] = EventId;
    _EventIdToNameTable[EventId] = Event.Name();
}

string TKcomComponentDescriptor::PropertyNameOf(int PropertyId)
{
    if (_PropertyIdToNameTable.count(PropertyId) > 0) {
	return _PropertyIdToNameTable[PropertyId];
    }
    else {
	return "";
    }    
}

const vector<pair<TKorbObjectMessenger*, TKcomObjectDeclaration> >& TKcomComponentDescriptor::ExportObjectList(void)
{
    return _ExportObjectList;
}

const vector<pair<TKorbObjectProxy*, TKcomObjectDeclaration> >& TKcomComponentDescriptor::ImportObjectList(void)
{
    return _ImportObjectList;
}

string TKcomComponentDescriptor::EventNameOf(int EventId)
{
    if (_EventIdToNameTable.count(EventId) > 0) {
	return _EventIdToNameTable[EventId];
    }
    else {
	return "";
    }
}

int TKcomComponentDescriptor::EventIdOf(const string& EventName)
{
    map<string, int>::iterator EventEntry;
    EventEntry = _EventNameToIdTable.find(EventName);

    if (EventEntry != _EventNameToIdTable.end()) {
	return (*EventEntry).second;
    }
    else {
	return -1;
    }
}

