/* KcomConsoleTerminal.cc */
/* Created by Enomoto Sanshiro on 16 April 2000. */
/* Last updated by Enomoto Sanshiro on 24 April 2000. */


#include <iostream>
#include <string>
#include "MushProcess.hh"
#include "MushConsole.hh"
#include "MushMisc.hh"
#include "KcomTerminal.hh"
#include "KcomConsoleTerminal.hh"

using namespace std;


TKcomConsoleTerminal::TKcomConsoleTerminal(void)
{
    _Console = new TMushReadlineConsole();
    _InputStream = new TMushInputConsoleStream(_Console);
    _OutputStream = new TMushOutputConsoleStream(_Console);
}

TKcomConsoleTerminal::~TKcomConsoleTerminal()
{
    delete _OutputStream;
    delete _InputStream;
    delete _Console;
}

int TKcomConsoleTerminal::Put(const string& Line) throw(TKcomException)
{
    (*_OutputStream) << Line << flush;

    return _OutputStream->good();
}

int TKcomConsoleTerminal::Get(string& Line, char Delimiter) throw(TKcomException)
{
    getline(*_InputStream, Line, Delimiter);

    return _InputStream->good() && (! _InputStream->eof());
}

void TKcomConsoleTerminal::SetPrompt(const string& Prompt) throw(TKcomException)
{
    _Console->SetPrompt(Prompt);
}



TKcomConsoleTerminalClient::TKcomConsoleTerminalClient(const string& Name, TKorbOrb* Orb, const string& Display)
: TKcomTerminalClient(Name, Orb)
{
    _ServerProcess = 0;
    _Display = Display;
}

TKcomConsoleTerminalClient::~TKcomConsoleTerminalClient()
{
    delete _ServerProcess;
}

void TKcomConsoleTerminalClient::LaunchServer(void) throw(TKcomException)
{
    string KinokoRoot;
    string XtermPath;
    try {
        //...
        KinokoRoot = TMushEnvironmentVariable("KINOKO_ROOT").AsString();
        XtermPath = TMushEnvironmentVariable("KINOKO_XTERM").AsString();
    }
    catch (TSystemCallException &e) {
        throw TKcomException(
            "TKcomTerminalClient::LaunchServer()",
            "system call exception: " + e.Message()
        );
    }
    string ServerPath = KinokoRoot + "/bin";

    vector<string> ArgumentList;
    ArgumentList.push_back(XtermPath);
    if (! _Display.empty()) {
	ArgumentList.push_back("-display");
	ArgumentList.push_back(_Display);
    }	
    ArgumentList.push_back("-T");
    ArgumentList.push_back(_Name);
    ArgumentList.push_back("-e");
    ArgumentList.push_back(ServerPath + "/" + "kcom-console-terminal");
    ArgumentList.push_back(_ServerName);

    try {
	_ServerProcess = new TMushChildProcess(XtermPath, ArgumentList);
	_ServerProcess->Run();
    }
    catch (TSystemCallException &e) {
	delete _ServerProcess;
	_ServerProcess = 0;

	throw TKcomException(
	    "TKcomTerminalClient::LaunchServer(): ",
	    "system call exception: " + e.Message()
	);
    }
}
