/* KcomConsoleTerminal.hh */
/* Created by Enomoto Sanshiro on 16 April 2000. */
/* Last updated by Enomoto Sanshiro on 16 April 2000. */


#ifndef __KcomConsoleTerminal_hh__
#define __KcomConsoleTerminal_hh__


#include <string>
#include <iostream>
#include "MushConsoleStream.hh"
#include "KcomTerminal.hh"


class TKcomConsoleTerminal: public TKcomTerminal {
  public:
    TKcomConsoleTerminal(void);
    virtual ~TKcomConsoleTerminal();
    virtual int Put(const std::string& Line) throw(TKcomException);
    virtual int Get(std::string& Line, char Delimiter = '\n') throw(TKcomException);
    virtual void SetPrompt(const std::string& Prompt) throw(TKcomException);
  protected:
    TMushConsole* _Console;
    std::istream* _InputStream;
    std::ostream* _OutputStream;
};


class TKcomConsoleTerminalClient: public TKcomTerminalClient {
  public:
    TKcomConsoleTerminalClient(const std::string& Name, TKorbOrb* Orb, const std::string& Display = "");
    virtual ~TKcomConsoleTerminalClient();
  protected:
    virtual void LaunchServer(void) throw(TKcomException);
  protected:
    TMushChildProcess* _ServerProcess;
    std::string _Display;
};


#endif
