/* KcomEventProcessor.hh */
/* Created by Enomoto Sanshiro on 27 March 2000. */
/* Last updated by Enomoto Sanshiro on 13 April 2002. */


#ifndef __KcomEventProcessor_hh__
#define __KcomEventProcessor_hh__


#include <string>
#include <vector>
#include <map>
#include <deque>
#include "KorbOrb.hh"
#include "KcomDefs.hh"
#include "KcomEvent.hh"
#include "KcomComponentOrb.hh"


class TKcomEventProcessor {
  public:
    TKcomEventProcessor(TKorbOrb* _Orb);
    virtual ~TKcomEventProcessor();
    virtual int RegisterComponent(const std::string& ComponentName);
    virtual int ProcessEvent(TKcomEvent& Event) throw(TKcomException) = 0;
    virtual int EmitEvent(const std::string& TargetName, TKcomEvent& Event, TKcomEventResponse& EventResponse) throw(TKcomException);
    virtual int WaitForNextReply(TKcomEventResponse& EventResponse) throw(TKcomException);
    virtual void EnterAsynchronousMode(void);
    virtual void ExitAsynchronousMode(void);
    virtual void EnterOnewayMode(void);
    virtual void ExitOnewayMode(void);
    virtual void SetTimeout(int Timeout_sec);
    virtual void EnableTimeout(void);
    virtual void DisableTimeout(void);
  protected:
    virtual int EmitEventTo(TKcomComponentProxy* ComponentProxy, TKcomEvent& Event, bool IsOneWay) throw(TKcomException);
    virtual int WaitForReplyFrom(TKcomComponentProxy* ComponentProxy, int RequestId, TKcomEventResponse& EventResponse) throw(TKcomException);
    virtual void DismissComponent(TKcomComponentProxy* ComponentProxy) throw(TKcomException);
  private:
    std::map<std::string, TKcomComponentProxy*> _ComponentTable;    
    std::map<std::string, TKcomComponentProxy*> _DismissedComponentTable;
    std::deque<std::pair<TKcomComponentProxy*, int> > _EventQueue;
    TKorbOrb* _Orb;
    int _Timeout_sec;
    bool _IsTimeoutEnabled;
    bool _IsInAsynchronousMode;
    bool _IsInOnewayMode;
};


#endif

