/* KcomExchangeCenter.hh */
/* Created by Enomoto Sanshiro on 27 March 2000. */
/* Last updated by Enomoto Sanshiro on 31 March 2000. */


#ifndef __KcomExchangeCenter_hh__
#define __KcomExchangeCenter_hh__


#include <string>
#include "KorbOrb.hh"
#include "KorbObjectAdapter.hh"
#include "KorbObjectReference.hh"
#include "KorbObjectProxy.hh"
#include "KorbObjectMessenger.hh"
#include "KcomDefs.hh"
#include "KcomEvent.hh"

class TKcomObjectAssembler;
class TKcomEventProcessor;


class TKcomExchangeCenter {
  public:
    TKcomExchangeCenter(TKcomObjectAssembler* ObjectAssembler, TKcomEventProcessor* EventProcessor);
    virtual ~TKcomExchangeCenter();
    virtual int ImportObject(const std::string& ClassName, const std::string& ImportName, TKorbObjectReference& ObjectReference) throw(TKcomException);
    virtual int ProcessEvent(TKcomEvent& Event) throw(TKcomException);
    virtual void EmitEventTo(const std::string& TargetName, TKcomEvent& Event, TKcomEventResponse& EventResponse) throw(TKcomException);
    virtual void AttachComponent(const std::string& ComponentName) throw(TKcomException);
    virtual void DetachComponent(const std::string& ComponentName) throw(TKcomException);
    virtual int NumberOfAttachedComponents(void);
  protected:
    TKcomObjectAssembler* _ObjectAssembler;
    TKcomEventProcessor* _EventProcessor;
    int _NumberOfAttachedComponents;
};


class TKcomExchangeCenterProxy: public TKorbObjectProxy, public TKcomExchangeCenter {
  public:
    TKcomExchangeCenterProxy(TKorbOrb* Orb);
    virtual ~TKcomExchangeCenterProxy();
    virtual int ImportObject(const std::string& ClassName, const std::string& ImportName, TKorbObjectReference& ObjectReference) throw(TKcomException);
    virtual void AttachComponent(const std::string& ComponentName) throw(TKcomException);
    virtual void DetachComponent(const std::string& ComponentName) throw(TKcomException);
    virtual int ProcessEvent(TKcomEvent& Event) throw(TKcomException);
    virtual int ProcessEventOneWay(TKcomEvent& Event) throw(TKcomException);
    virtual void EmitEventTo(const std::string& TargetName, TKcomEvent& Event, TKcomEventResponse& EventResponse) throw(TKcomException);
};


class TKcomExchangeCenterMessenger: public TKorbObjectMessenger {
  public:
    enum TMethodId {
	MethodId_ProcessEvent,
	MethodId_EmitEventTo,
	MethodId_ImportObject,
	MethodId_AttachComponent,
	MethodId_DetachComponent
    };
  public:
    TKcomExchangeCenterMessenger(TKcomExchangeCenter* ExchangeCenter);
    virtual ~TKcomExchangeCenterMessenger();
    virtual int DispatchMethodInvocation(TKorbOrbPacket& OrbPacket) throw(TKorbException);
  protected:
    virtual int ProcessEvent(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    virtual int EmitEventTo(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    virtual int ImportObject(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    virtual int AttachComponent(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    virtual int DetachComponent(TKorbOrbPacket& OrbPacket) throw(TKorbException);
  protected:
    TKcomExchangeCenter* _ExchangeCenter;
};


#endif
