/* KcomInterfaceDeclaration.hh */
/* Created by Enomoto Sanshiro on 25 March 2000. */
/* Last updated by Enomoto Sanshiro on 31 March 2000. */


#ifndef __KcomInterfaceDeclaration_hh__
#define __KcomInterfaceDeclaration_hh__

#include <iostream>
#include <string>
#include <vector>



class TKcomPropertyDeclaration {
  public:
    enum TPropertyType {
	Type_Int,
	Type_Long,
	Type_Float,
	Type_Double,
	Type_String,
	NumberOfPropertyTypes
    };
  public:
    TKcomPropertyDeclaration(void);
    TKcomPropertyDeclaration(const std::string& Name, TPropertyType Type);
    TKcomPropertyDeclaration(const TKcomPropertyDeclaration& PropertyDeclaration);
    TKcomPropertyDeclaration& operator=(const TKcomPropertyDeclaration& PropertyDeclaration);
    virtual ~TKcomPropertyDeclaration();
    virtual void SetComment(const std::string& Comment);
    virtual std::string Name(void) const;
    virtual TPropertyType Type(void) const;
    virtual std::string TypeAsString(void) const;
    virtual void Print(std::ostream& os) const;
  protected:
    std::string _Name;
    TPropertyType _Type;
    std::string _Comment;
};


class TKcomEventDeclaration {
  public:
    TKcomEventDeclaration(void);
    TKcomEventDeclaration(const std::string Name);
    TKcomEventDeclaration(const TKcomEventDeclaration& EventDeclaration);
    TKcomEventDeclaration& operator=(const TKcomEventDeclaration& EventDeclaration);
    virtual ~TKcomEventDeclaration();
    virtual void AddArgument(const TKcomPropertyDeclaration& Argument);
    virtual void SetComment(const std::string& Comment);
    virtual std::string Name(void) const;
    virtual std::vector<TKcomPropertyDeclaration>& ArgumentList(void);
    virtual void Print(std::ostream& os) const;
  protected:
    std::string _Name;
    std::vector<TKcomPropertyDeclaration> _ArgumentList;
    std::string _Comment;
};


class TKcomObjectDeclaration {
  public:
    TKcomObjectDeclaration(void);
    TKcomObjectDeclaration(const std::string& ClassName, const std::string& ObjectName);
    TKcomObjectDeclaration(const TKcomObjectDeclaration& ObjectDeclaration);
    TKcomObjectDeclaration& operator=(const TKcomObjectDeclaration& ObjectDeclaration);
    virtual ~TKcomObjectDeclaration();
    virtual void SetComment(const std::string& Comment);
    virtual std::string ClassName(void) const;
    virtual std::string ObjectName(void) const;
    virtual void Print(std::ostream& os) const;
  protected:
    std::string _ClassName;
    std::string _ObjectName;
    std::string _Comment;
};



class TKcomComponentDeclaration {
  public:
    TKcomComponentDeclaration(const std::string& TypeName);
    virtual ~TKcomComponentDeclaration();
    virtual void Print(std::ostream& os);
    virtual void AddComment(const std::string& Comment);
    virtual void SetAuthor(const std::string& Author);
    virtual void SetDate(const std::string& Date);
    virtual void SetVersion(int MajorVersion, int MinorVersion);  
    virtual void AddProperty(const TKcomPropertyDeclaration& Property);
    virtual void AddEventSource(const TKcomEventDeclaration& Event);
    virtual void AddEventSlot(const TKcomEventDeclaration& Event);
    virtual void AddExportObject(const TKcomObjectDeclaration& Object);
    virtual void AddImportObject(const TKcomObjectDeclaration& Object);
  private:
    std::string _TypeName;
    std::string _Author;
    std::string _Date;
    int _MajorVersion, _MinorVersion;
    std::vector<std::string> _CommentList;
    std::vector<TKcomPropertyDeclaration> _PropertyTable;
    std::vector<TKcomEventDeclaration> _EventSourceTable;
    std::vector<TKcomEventDeclaration> _EventSlotTable;
    std::vector<TKcomObjectDeclaration> _ExportObjectTable;
    std::vector<TKcomObjectDeclaration> _ImportObjectTable;
};


#endif
