/* KcomProcess.hh */
/* Created by Enomoto Sanshiro on 25 March 2000. */
/* Last updated by Enomoto Sanshiro on 24 May 2000. */


#ifndef __KcomProcess_hh__
#define __KcomProcess_hh__


#include <iostream>
#include <string>
#include "MushSignal.hh"
#include "MushNetworkSocket.hh"
#include "MushArgumentList.hh"
#include "KorbOrb.hh"
#include "KorbObjectAdapter.hh"
#include "KorbObjectMessenger.hh"
#include "KcomDefs.hh"
#include "KcomComponent.hh"
#include "KcomTerminal.hh"
#include "KcomConsoleTerminal.hh"


class TKcomProcess {
  public:
    TKcomProcess(TKcomComponent *Component);
    virtual ~TKcomProcess();
    virtual void Start(TMushArgumentList& ArgumentList) throw(TKcomException);
  protected:
    virtual void AttachIO(const std::string& Control) throw(TKcomException);
    virtual void AttachSocketIO(int PortNumber) throw(TKcomException);
    virtual void AttachTerminalIO(const std::string& Display = "") throw(TKcomException);
    virtual void AttachFileIO(const std::string& FileName = "") throw(TKcomException);
    virtual void AttachConsoleIO(void) throw(TKcomException);
    virtual void AttachNullIO(void) throw(TKcomException);
    virtual void AttachSystem(void) throw(TKcomException);
    virtual void DetachSystem(void) throw(TKcomException);
    virtual void DetachIO(void) throw(TKcomException);
    virtual void StartTransaction(void) throw(TKcomException);
  private:
    TKorbOrb* _Orb;
    TKorbObjectAdapter* _ObjectAdapter;
    TKorbObjectMessenger* _ComponentMessenger;
    TKcomComponent* _Component;
    std::string _ComponentName;
    bool _ExportsObject;
  private:
    std::istream* _InputStream;
    std::ostream* _OutputStream;
    TKcomTerminal* _Terminal;
    TKcomTerminalClient* _TerminalClient;
    TMushServerNetworkSocket* _Socket;
    TKcomTerminal* _LocalTerminal;
};


#endif
