/* KcomRegistryRepository.hh */
/* Created by Enomoto Sanshiro on 27 May 2000. */
/* Last updated by Enomoto Sanshiro on 19 May 2003. */


#ifndef __KcomRegistryRepository_hh__
#define __KcomRegistryRepository_hh__

#include <iostream>
#include <string>
#include "KcomDefs.hh"
#include "KcomRegistry.hh"
#include "ParaTokenizer.hh"


class TKcomRegistryRepository {
  public:
    TKcomRegistryRepository(const std::string& FileName);
    virtual ~TKcomRegistryRepository();
    virtual void Save(TKcomRegistry* Registry, const std::string& BasePath = "/") throw(TKcomException);
    virtual TKcomRegistry* Load(void) throw(TKcomException);
  protected:
    virtual void WriteChildEntries(TKcomRegistryEntry* Entry, std::ostream& os, std::string Indent = "");
    virtual void ReadChildEntries(TKcomRegistryEntry* Entry, TParaTokenizer& Tokenizer) throw(TScriptException);
  protected:
    std::string _FileName;
};


class TKcomXmlRegistryRepository: public TKcomRegistryRepository {
  public:
    TKcomXmlRegistryRepository(const std::string& FileName);
    virtual ~TKcomXmlRegistryRepository();
    virtual void Save(TKcomRegistry* Registry, const std::string& BasePath = "/") throw(TKcomException);
    virtual TKcomRegistry* Load(void) throw(TKcomException);
  protected:
    virtual void WriteChildEntries(TKcomRegistryEntry* Entry, std::ostream& os, std::string Indent = "");
    virtual void ReadChildEntries(TKcomRegistryEntry* Entry, TParaTokenizer& Tokenizer) throw(TScriptException);
};


#endif
