/* KcomScript.hh */
/* Created by Enomoto Sanshiro on 8 April 2000. */
/* Last updated by Enomoto Sanshiro on 19 May 2003. */


#ifndef __KcomScript_hh__
#define __KcomScript_hh__


#include <string>
#include <vector>
#include "KiscScript.hh"
#include "KcomEvent.hh"
#include "KcomRegistry.hh"
#include "KcomComponentAssembler.hh"
#include "KcomObjectAssembler.hh"
#include "KcomEventProcessor.hh"


class TKcomScript: public TKiscScript {
  public:
    TKcomScript(TKcomManager* Manager, int argc, char** argv);
    virtual ~TKcomScript();
    virtual int ExecuteHook(const std::string& EntryName) throw(TKcomException);
    virtual int DispatchEvent(TKcomEvent& Event) throw(TKcomException);
    virtual void AddTimeHook(long Interval, TParaPackageEntry* Entry);
    virtual int ExecuteTimeHook(long Time) throw(TKcomException);
  protected:
    virtual TParaObjectPrototypeTable* CreateObjectPrototypeTable(void);
    virtual TParaBuiltinFunctionTable* CreateBuiltinFunctionTable(void);
    virtual TParaTokenTable* CreateTokenTable(void);
    virtual TParaOperatorTable* CreateOperatorTable(void);
    virtual TParaStatementTable* CreateStatementTable(void);
    virtual TParaPackage* CreatePackage(void);
  protected:
    TKcomManager* _Manager;
    TKcomComponentAssembler* _ComponentAssembler;
    TKcomObjectAssembler* _ObjectAssembler;
    TKcomEventProcessor* _EventProcessor;
    TKcomRegistry* _Registry;
  protected:
    std::vector<std::pair<long, TParaPackageEntry*> > _TimeHookTable;
    std::vector<long> _NextExecutionTimeTable;
};


class TKcomEventHandler: public TParaCxxFunction {
  public:
    TKcomEventHandler(void);
    virtual ~TKcomEventHandler();
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    static std::string HandlerNameOf(const std::string& ObjectName, const std::string& EventName);
    static std::string AnonymousObjectName(void);
    static std::string ManagerObjectName(void);
  protected:
    std::string _ObjectName;
    std::string _EventName;
};


class TKcomImportStatement: public TParaStatement {
  public:
    TKcomImportStatement(TKcomComponentAssembler* ComponentAssembler, TKcomEventProcessor* EventProcessor, TKcomRegistry* Registry);
    virtual ~TKcomImportStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKcomComponentAssembler* _ComponentAssembler;
    TKcomEventProcessor* _EventProcessor;
    TKcomRegistry* _Registry;
};


class TKcomAssignStatement: public TParaStatement {
  public:
    TKcomAssignStatement(TKcomObjectAssembler* ObjectAssembler);
    virtual ~TKcomAssignStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKcomObjectAssembler* _ObjectAssembler;
    std::string _ProviderName, _ProviderObjectName;
    std::string _UserName, _UserObjectName;
};


class TKcomAsynchronousStatement: public TParaStatement {
  public:
    TKcomAsynchronousStatement(TKcomEventProcessor* EventProcessor);
    virtual ~TKcomAsynchronousStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKcomEventProcessor* _EventProcessor;
    TParaStatement* _Statement;
};


class TKcomOnewayStatement: public TParaStatement {
  public:
    TKcomOnewayStatement(TKcomEventProcessor* EventProcessor);
    virtual ~TKcomOnewayStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKcomEventProcessor* _EventProcessor;
    TParaStatement* _Statement;
};


class TKcomEventHandlerEntry: public TParaPackageEntry {
  public:
    TKcomEventHandlerEntry(void);
    virtual ~TKcomEventHandlerEntry();
    virtual TParaPackageEntry* Clone(void);
    virtual bool HasEntryWordsOf(TParaTokenizer* Tokenizer);
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TParaValue Execute(const std::vector<TParaValue*>& ArgumentList, TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKcomEventHandler* _EventHandler;
};


class TKcomTimeHookEntry: public TParaPackageEntry {
  public:
    TKcomTimeHookEntry(TKcomScript* Script);
    virtual ~TKcomTimeHookEntry();
    virtual TParaPackageEntry* Clone(void);
    virtual bool HasEntryWordsOf(TParaTokenizer* Tokenizer);
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TParaValue Execute(const std::vector<TParaValue*>& ArgumentList, TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKcomScript* _Script;
    TParaStatement* _Statement;
};


class TKcomExitStatement: public TParaStatement {
  public:
    TKcomExitStatement(void);
    virtual ~TKcomExitStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TParaStatementParser* _StatementParser;
};


//... for backward compatibility ...//
class TKcomComponentStatement: public TParaStatement {
  public:
    TKcomComponentStatement(void);
    virtual ~TKcomComponentStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
};


class TKcomSystemScriptMessenger: public TParaObjectPrototype {
  public:
    TKcomSystemScriptMessenger(TKcomManager* Manager);
    virtual ~TKcomSystemScriptMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    TParaValue SetTimeout(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue EnableTimeout(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue DisableTimeout(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  protected:
    TKcomManager* _Manager;
};


class TKcomComponentScriptMessenger: public TParaObjectPrototype {
  public:
    TKcomComponentScriptMessenger(TKcomComponentAssembler* ComponentAssembler, TKcomEventProcessor* EventProcessor, TKcomRegistry* Registry);
    virtual ~TKcomComponentScriptMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int GetPropertyOf(const std::string& PropertyName, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    std::string _ComponentTypeName;
    std::string _ComponentName;
    std::string _Host, _Control;
    TKcomComponentAssembler* _ComponentAssembler;
    TKcomEventProcessor* _EventProcessor;
    TKcomRegistry* _Registry;
};


class TKcomRegistryScriptMessenger: public TParaObjectPrototype {
  public:
    TKcomRegistryScriptMessenger(TKcomRegistry* Registry);
    virtual ~TKcomRegistryScriptMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    TParaValue GetRegistry(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue SetRegistry(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue SaveRegistry(std::vector<TParaValue*>& ArgumentList, const std::string& FileType = "") throw(TScriptException);
  protected:
    TKcomRegistry* _Registry;
};


#endif
