/* KcomTerminal.hh */
/* Created by Enomoto Sanshiro on 16 April 2000. */
/* Last updated by Enomoto Sanshiro on 30 April 2000. */


#ifndef __KcomTerminal_hh__
#define __KcomTerminal_hh__

#include <string>
#include "MushProcess.hh"
#include "KorbOrb.hh"
#include "KorbObjectMessenger.hh"
#include "KorbObjectAdapter.hh"
#include "KcomDefs.hh"


class TKcomTerminal {
  public:
    TKcomTerminal(void);
    virtual ~TKcomTerminal();
    virtual int Put(const std::string& Line) throw(TKcomException) = 0;
    virtual int Get(std::string& Line, char Delimiter = '\n') throw(TKcomException) = 0;
    virtual void SetPrompt(const std::string& Prompt) throw(TKcomException) = 0;
};


class TKcomTerminalProxy: public TKcomTerminal {
  public:
    TKcomTerminalProxy(const TKorbObjectReference& ObjectReference, TKorbOrb* Orb);
    virtual ~TKcomTerminalProxy();
    virtual int Put(const std::string& Line) throw(TKcomException);
    virtual int Get(std::string& Line, char Delimiter = '\n') throw(TKcomException);
    virtual void SetPrompt(const std::string& Prompt) throw(TKcomException);
  protected:
    TKorbObjectReference _ObjectReference;
    TKorbOrb* _Orb;
};


class TKcomTerminalMessenger: public TKorbObjectMessenger {
  public:
    enum TMethodId {
	MethodId_Put,
	MethodId_Get,
	MethodId_SetPrompt,
	NumberOfMethods
    };
  public:
    TKcomTerminalMessenger(TKcomTerminal* KcomTerminal);
    virtual ~TKcomTerminalMessenger();
    virtual int DispatchMethodInvocation(TKorbOrbPacket& OrbPacket) throw(TKorbException);
  protected:
    TKcomTerminal* _KcomTerminal;
};


class TKcomTerminalServer {
  public:
    TKcomTerminalServer(const std::string& Name, TKcomTerminal* KcomTerminal);
    virtual ~TKcomTerminalServer();
    virtual void Start(void) throw(TKcomException);
  protected:
    std::string _Name;
    TKorbOrb* _Orb;
    TKorbObjectAdapter* _ObjectAdapter;
    TKorbObjectMessenger* _KcomTerminalMessenger;
    TKcomTerminal* _KcomTerminal;
};


class TKcomTerminalClient {
  public:
    TKcomTerminalClient(const std::string& Name, TKorbOrb* Orb);
    virtual ~TKcomTerminalClient();
    virtual TKcomTerminal* Attach(void) throw(TKcomException);
    virtual void Detach(void) throw(TKcomException);
  protected:
    virtual void LaunchServer(void) throw(TKcomException) = 0;
  protected:
    std::string _Name;
    std::string _ServerName;
    TKorbOrb* _Orb;
    TKcomTerminal* _KcomTerminal;
    TKorbObjectReference _Reference;
};


#endif
