/* KcomTerminalStream.cc */
/* Created by Enomoto Sanshiro on 30 April 2000. */
/* Last updated by Enomoto Sanshiro on 30 April 2000. */


#include <iostream>
#include <cstring>
#include <string>
#include "KcomTerminal.hh"
#include "KcomTerminalStream.hh"

using namespace std;


static const int DefaultBufferSize = 64;


TKcomTerminalStreamBuffer::TKcomTerminalStreamBuffer(TKcomTerminal* Terminal)
{
    _Terminal = Terminal;

    _BufferSize = DefaultBufferSize;
    _Buffer = new char[_BufferSize + 1]; // '+1' is for terminator
    
    char* Begin = _Buffer;
    char* End = _Buffer + _BufferSize;
    setp(Begin, End);
    setg(Begin, End, End);

    _Remain.erase();
}

TKcomTerminalStreamBuffer::~TKcomTerminalStreamBuffer()
{
    delete[] _Buffer;
}

int TKcomTerminalStreamBuffer::overflow(int ch)
{
    sync();

    if (ch != EOF) {
	*pptr() = ch;
	pbump(1);
    }
    
    return ch;
}

int TKcomTerminalStreamBuffer::underflow(void)
{
    string Line;
    if (_Remain.empty()) {
	if (! _Terminal->Get(Line, '\n')) {
	    return EOF;
	}
	else {
	    Line += '\n';
	}
    }
    else {
	Line = _Remain;
	_Remain.erase();
    }

    int Size = Line.size();
    if (Size > _BufferSize) {
	Size = _BufferSize;
	_Remain = string(Line.data() + _BufferSize);
    }

    memcpy(_Buffer, Line.data(), Size);

    char* Begin = _Buffer;
    char* Next = _Buffer;
    char* End = _Buffer + Size;
    setg(Begin, Next, End);

    return *gptr();
}

int TKcomTerminalStreamBuffer::sync(void) 
{
    if (pptr() == _Buffer) {
	return 0;
    }

    *pptr() = '\0';
    _Terminal->Put(string(_Buffer));

    char* Begin = _Buffer;
    char* End = _Buffer + _BufferSize;
    setp(Begin, End);

    return 0;
}



TKcomInputTerminalStream::TKcomInputTerminalStream(TKcomTerminal* Terminal)
: istream(_StreamBuffer = new TKcomTerminalStreamBuffer(Terminal))
{
}

TKcomInputTerminalStream::~TKcomInputTerminalStream() 
{
    delete _StreamBuffer;
}

TKcomTerminalStreamBuffer* TKcomInputTerminalStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}


TKcomOutputTerminalStream::TKcomOutputTerminalStream(TKcomTerminal* Terminal)
: ostream(_StreamBuffer = new TKcomTerminalStreamBuffer(Terminal))
{
}

TKcomOutputTerminalStream::~TKcomOutputTerminalStream() 
{
    delete _StreamBuffer;
}

TKcomTerminalStreamBuffer* TKcomOutputTerminalStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}
