/* KcomTerminalStream.hh */
/* Created by Enomoto Sanshiro on 30 April 2000. */
/* Last updated by Enomoto Sanshiro on 30 April 2000. */


#ifndef __KcomTerminalStream_hh__
#define __KcomTerminalStream_hh__

#include <iostream>
#include <string>
#include "KcomTerminal.hh"



class TKcomTerminalStreamBuffer: public std::streambuf {
  public:
    TKcomTerminalStreamBuffer(TKcomTerminal* Terminal);
    virtual ~TKcomTerminalStreamBuffer();
  protected:
    virtual int overflow(int ch = EOF);
    virtual int underflow(void);
    virtual int sync(void);
  private:
    TKcomTerminal* _Terminal;
    char *_Buffer;
    int _BufferSize;
    std::string _Remain;
};


class TKcomInputTerminalStream: public std::istream {
  public:
    TKcomInputTerminalStream(TKcomTerminal* Terminal);
    virtual ~TKcomInputTerminalStream();
    virtual TKcomTerminalStreamBuffer* rdbuf(void);
  private:
    TKcomTerminalStreamBuffer* _StreamBuffer;
};


class TKcomOutputTerminalStream: public std::ostream {
  public:
    TKcomOutputTerminalStream(TKcomTerminal* Terminal);
    virtual ~TKcomOutputTerminalStream();
    virtual TKcomTerminalStreamBuffer* rdbuf(void);
  private:
    TKcomTerminalStreamBuffer* _StreamBuffer;
};


#endif
