/* kcom-manager.cc */
/* Created by Enomoto Sanshiro on 28 March 2000. */
/* Last updated by Enomoto Sanshiro on 28 March 2000. */


#include <iostream>
#include "MushArgumentList.hh"
#include "KcomManager.hh"
#include "KcomScriptedManager.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);
    if (ArgumentList.NumberOfParameters() < 1) {
	cerr << "usage: " << argv[0] << " KcomScriptFileName" << endl;
	return 0;
    }
    string ScriptFileName = ArgumentList[0];

    try {
	TKcomScriptedManager(ScriptFileName, argc - 1, argv + 1).Start();
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }
    
    return 0;
}
