/* fibonacci-kcom.cc */
/* Created by Enomoto Sanshiro on 27 March 2000. */
/* Last updated by Enomoto Sanshiro on 27 March 2000. */


#include <fstream>
#include <strstream>
#include <string>
#include "MushTimer.hh"
#include "KcomComponent.hh"
#include "KcomProcess.hh"
#include "KcomTerminalStream.hh"

using namespace std;


static const string Author = "Enomoto Sanshiro";
static const string Date = "27 Mar 2000";
static const int MajorVersion = 0;
static const int MinorVersion = 1;


class TFibonacciCom: public TKcomComponent {
  public:
    TFibonacciCom(void);
    virtual ~TFibonacciCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual void Initialize(void) throw(TKcomException);
    virtual void Finalize(void) throw(TKcomException);
    virtual int DoTransaction(void) throw(TKcomException);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
  protected:
    virtual int ProcessSetInitialEvent(TKcomEvent& Event);
  private:
    enum TEventId {
	EventId_SetInitial,
	EventId_Start,
	EventId_Stop,
	EventId_Clear,
	EventId_Quit,
	_NumberOfEvents
    };
    enum TState {
	State_Initial,
	State_Running,
	State_Idle,
	_NumberOfStates
    };
  private:
    TState _State;
    int _Index;
    long _InitialValue_0, _InitialValue_1;
    long _PrevValue, _CurrentValue;
};


TFibonacciCom::TFibonacciCom(void)
: TKcomComponent("FibonacciCom")
{
    _State = State_Initial;

    _InitialValue_0 = 0;
    _InitialValue_1 = 1;

    _Index = 0;
    _PrevValue = _InitialValue_0;
    _CurrentValue = _InitialValue_1;
}

TFibonacciCom::~TFibonacciCom()
{
}

void TFibonacciCom::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKcomComponent::BuildDescriptor(Descriptor);

    Descriptor.SetAuthor(Author);
    Descriptor.SetDate(Date);
    Descriptor.SetVersion(MajorVersion, MinorVersion);

    Descriptor.AddComment("sample component process for KinokoComponents");
    Descriptor.AddComment("calculates Fibonacci series");

    TKcomEventDeclaration SetInitialEvent("setInitial");
    SetInitialEvent.AddArgument(
	TKcomPropertyDeclaration("first", TKcomPropertyDeclaration::Type_Int)
    );
    SetInitialEvent.AddArgument(
	TKcomPropertyDeclaration("second", TKcomPropertyDeclaration::Type_Int)
    );
    SetInitialEvent.SetComment("set a[0] and a[1] value");
    Descriptor.RegisterEventSlot(EventId_SetInitial, SetInitialEvent);

    TKcomEventDeclaration StartEvent("start");
    StartEvent.SetComment("start calculating Fibonacci series");
    Descriptor.RegisterEventSlot(EventId_Start, StartEvent);

    TKcomEventDeclaration StopEvent("stop");
    StopEvent.SetComment("stop calculating Fibonacci series");
    Descriptor.RegisterEventSlot(EventId_Stop, StopEvent);

    TKcomEventDeclaration ClearEvent("clear");
    ClearEvent.SetComment("clear index");
    Descriptor.RegisterEventSlot(EventId_Clear, ClearEvent);

    TKcomEventDeclaration QuitEvent("quit");
    QuitEvent.SetComment("quit");
    Descriptor.RegisterEventSlot(EventId_Quit, QuitEvent);
}

void TFibonacciCom::Initialize(void) throw(TKcomException)
{
}

void TFibonacciCom::Finalize(void) throw(TKcomException)
{
    string UserName;
    GetPropertyOf("controller", "user_name", UserName);
    OutputStream() << "Bye bye, " << UserName << "." << endl;
}

int TFibonacciCom::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    switch (EventId) {
      case EventId_SetInitial:
	ProcessSetInitialEvent(Event);
	break;

      case EventId_Start:
	_State = State_Running;
	break;

      case EventId_Stop:
	_State = State_Idle;
	break;

      case EventId_Clear:
	_Index = 0;
	_PrevValue = _InitialValue_0;
	_CurrentValue = _InitialValue_1;
	break;

      case EventId_Quit:	
        Terminate();
	break;

      default:
	return TKcomComponent::ProcessEvent(EventId, Event, EventResponse);
    }

    return 1;
}

int TFibonacciCom::DoTransaction(void) throw(TKcomException)
{
    if (_State == State_Running) {
	long NextValue = _PrevValue + _CurrentValue;
	
	_Index++;
	_PrevValue = _CurrentValue;
	_CurrentValue = NextValue;
	
	OutputStream() << _Index << " " << _CurrentValue << endl;
	TMushRealTimeTimer(0, 900000).Suspend();
    }
    
    TMushRealTimeTimer(0, 100000).Suspend();

    return 1;
}

int TFibonacciCom::ProcessSetInitialEvent(TKcomEvent& Event)
{
    istrstream is0(Event.ArgumentList()[0].c_str()); is0 >> _InitialValue_0;
    istrstream is1(Event.ArgumentList()[1].c_str()); is1 >> _InitialValue_1;

    _Index = 0;
    _PrevValue = _InitialValue_0;
    _CurrentValue = _InitialValue_1;

    return 1;
}


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    TKcomComponent* Component = new TFibonacciCom();
    TKcomProcess* ComProcess = new TKcomProcess(Component);

    try {
	ComProcess->Start(ArgumentList);
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    delete ComProcess;
    delete Component;

    return 0;
}
