/* messageboard-kcom.cc */
/* Created by Enomoto Sanshiro on 20 August 2000. */
/* Last updated by Enomoto Sanshiro on 20 August 2000. */


#include <strstream>
#include <string>
#include "KcomComponent.hh"
#include "KcomProcess.hh"
#include "KcomTerminalStream.hh"
#include "MessageBoard.hh"

using namespace std;


static const string Author = "Enomoto Sanshiro";
static const string Date = "21 August 2000";
static const int MajorVersion = 0;
static const int MinorVersion = 1;


class TMessageBoardCom: public TKcomComponent {
  public:
    TMessageBoardCom(void);
    virtual ~TMessageBoardCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
  private:
    TMessageBoard* _MessageBoard;
    TKorbObjectMessenger* _ObjectMessenger;
  private:
    enum TEventId {
	EventId_Quit,
	_NumberOfEvents
    };
};


TMessageBoardCom::TMessageBoardCom(void)
: TKcomComponent("MessageBoardCom")
{
    _MessageBoard = 0;
    _ObjectMessenger = 0;
}

TMessageBoardCom::~TMessageBoardCom()
{
    delete _ObjectMessenger;
    delete _MessageBoard;
}

void TMessageBoardCom::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKcomComponent::BuildDescriptor(Descriptor);

    _MessageBoard = new TMessageBoard(&OutputStream());
    _ObjectMessenger = new TMessageBoardMessenger(_MessageBoard);

    Descriptor.SetAuthor(Author);
    Descriptor.SetDate(Date);
    Descriptor.SetVersion(MajorVersion, MinorVersion);

    Descriptor.RegisterExportObject(
	_ObjectMessenger, TKcomObjectDeclaration(
	    _ObjectMessenger->ClassName(), "message_board"
	)
    );

    TKcomEventDeclaration QuitEvent("quit");
    Descriptor.RegisterEventSlot(EventId_Quit, QuitEvent);
}

int TMessageBoardCom::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    switch (EventId) {
      case EventId_Quit:	
        Terminate();
	break;

      default:
	return TKcomComponent::ProcessEvent(EventId, Event, EventResponse);
    }

    return 1;
}

int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    TKcomComponent* Component = new TMessageBoardCom();
    TKcomProcess* ComProcess = new TKcomProcess(Component);

    try {
	ComProcess->Start(ArgumentList);
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    delete ComProcess;
    delete Component;

    return 0;
}
