/* MessageBoard.cc */
/* Created by Enomoto Sanshiro on 23 February 2000. */
/* Last updated by Enomoto Sanshiro on 23 February 2000. */


#include <iostream>
#include "MushMisc.hh"
#include "KorbOrb.hh"
#include "KorbObjectMessenger.hh"
#include "MessageBoard.hh"

using namespace std;


static const char* MessageBoardClassName = "MessageBoard";


TMessageBoard::TMessageBoard(ostream* OutputStream)
{
    _OutputStream = OutputStream;
}

TMessageBoard::~TMessageBoard()
{
}

int TMessageBoard::Write(string Name, string Contents)
{
    *_OutputStream << TMushDateTime().AsString() << ", ";
    *_OutputStream << Name << ": ";
    *_OutputStream << Contents << endl;

    return 0;
}



TMessageBoardProxy::TMessageBoardProxy(TKorbOrb* Orb)
: TKorbObjectProxy(MessageBoardClassName, Orb), TMessageBoard(0)
{
}

TMessageBoardProxy::~TMessageBoardProxy()
{
}

int TMessageBoardProxy::Write(string Name, string Contents)
{
    int MethodId = TMessageBoardMessenger::MethodId_Write;
    TKorbOrbPacket OrbPacket = CreateOrbPacket(MethodId);

    OrbPacket.ArgumentSerializer().PutString(Name);
    OrbPacket.ArgumentSerializer().PutString(Contents);

    try {
	InvokeMethod(OrbPacket);
    }
    catch (TKorbException& e) {
	throw e;
    }

    int Result;
    OrbPacket.ArgumentSerializer().GetInt(Result);

    return Result;
}



TMessageBoardMessenger::TMessageBoardMessenger(TMessageBoard* MessageBoard)
: TKorbObjectMessenger(MessageBoardClassName)
{
    _MessageBoard = MessageBoard;
}

TMessageBoardMessenger::~TMessageBoardMessenger()
{
}

int TMessageBoardMessenger::DispatchMethodInvocation(TKorbOrbPacket& OrbPacket) throw(TKorbException)
{
    if (OrbPacket.MethodId() == MethodId_Write) {
	string Name; string Contents;

	OrbPacket.ArgumentSerializer().GetString(Name);
	OrbPacket.ArgumentSerializer().GetString(Contents);

	int Result = _MessageBoard->Write(Name, Contents);

	OrbPacket.ArgumentSerializer().Rewind();
	OrbPacket.ArgumentSerializer().PutInt(Result);

	return 1;
    }

    return 0;
}
