/* kcom-terminal-test.cc */
/* Created by Enomoto Sanshiro on 26 April 2000. */
/* Last updated by Enomoto Sanshiro on 26 April 2000. */


#include <iostream>
#include "KcomTerminal.hh"
#include "KcomConsoleTerminal.hh"
#include "KcomTerminalStream.hh"

using namespace std;


int main(int argc, char** argv)
{
    string Name = "KcomTerminal test";

    TKorbOrb* Orb = 0;
    TKcomTerminalClient* TerminalClient = 0;
    TKcomTerminal* Terminal = 0;

    try {
	TKorbOrb* Orb = new TKorbOrb();
	TerminalClient = new TKcomConsoleTerminalClient(Name, Orb);
	Terminal = TerminalClient->Attach();
	TKcomOutputTerminalStream kcout(Terminal);

	while (1) {
	    string Message;
	    Terminal->Put("Say something: ");
	    Terminal->Get(Message);

	    cout << "She/He said, \"" << Message << "\"" << endl;
	    kcout << "You said, \"" <<  Message << "\"\n" << endl;

	    if (Message.empty() || Message == "bye") {
		break;
	    }
	}

	TerminalClient->Detach();
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << e << endl;
        cerr << "hint: you have to run 'korb-broker' prior to run this program" << endl;
    }
    
    delete TerminalClient;
    delete Orb;

    return 0;
}
