/* KdbcManager.cc */
/* Created by Enomoto Sanshiro on 3 November 2000. */
/* Last updated by Enomoto Sanshiro on 3 November 2000. */


#include <string>
#include <map>
#include "KdbcDefs.hh"
#include "KdbcDriver.hh"
#include "KdbcManager.hh"

using namespace std;


TKdbcManager* TKdbcManager::_Instance = 0;

TKdbcManager::TKdbcManager(void)
{
}

TKdbcManager::~TKdbcManager()
{
}

TKdbcManager* TKdbcManager::GetInstance(void)
{
    if (_Instance == 0) {
        _Instance = new TKdbcManager();
    }

    return _Instance;
}

void TKdbcManager::RegisterDriver(const string& DriverName, TKdbcDriver* Driver)
{
    _DriverTable[DriverName] = Driver;
}

TKdbcDriver* TKdbcManager::CreateDriver(const string& DriverName) throw(TKdbcException)
{
    if (DriverName.empty()) {
	if (_DriverTable.empty()) {
	    throw TKdbcException(
		"TKdbcManager::CreateDriver()", "no KDBC driver is registered"
	    );
	}
	return (*_DriverTable.begin()).second->Clone();
    }

    if (_DriverTable.count(DriverName) == 0) {
	throw TKdbcException(
	    "TKdbcManager::CreateDriver()", 
	    "unknown KDBC driver: " + DriverName
	);
    }

    return _DriverTable[DriverName]->Clone();
}

void TKdbcManager::ShowDriverList(std::ostream& os) const
{
    cout << "SQL Database Drivers:" << endl;
    map<string, TKdbcDriver*>::const_iterator Driver;
    for (
	 Driver = _DriverTable.begin();
	 Driver != _DriverTable.end();
	 Driver++
    ){
        os << "    " << Driver->first << endl;
    }
    os << endl;
}



TKdbcDriverCreator::TKdbcDriverCreator(const string& DriverName, TKdbcDriver* Driver)
{
    TKdbcManager::GetInstance()->RegisterDriver(DriverName, Driver);
}

