/* dbms-PostgreSQL.hh */
/* Created by Enomoto Sanshiro on 3 November 2000. */
/* Last updated by Enomoto Sanshiro on 3 November 2000. */


#ifndef __dbms_PostgreSQL_hh__
#define __dbms_PostgreSQL_hh__


#include <string>
#include <libpq-fe.h>
#include "KdbcManager.hh"
#include "KdbcDriver.hh"
#include "KdbcResult.hh"



class TKdbcDriver_PostgreSQL: public TKdbcDriver {
  public:
    TKdbcDriver_PostgreSQL(void);
    virtual ~TKdbcDriver_PostgreSQL();
    virtual TKdbcDriver* Clone(void);
    virtual TKdbcConnection* CreateConnection(const std::string& DatabaseName) throw(TKdbcException);
    virtual TKdbcConnection* CreateConnection(const std::string& DatabaseName, const std::string& Host, const std::string& Port, const std::string& UserName, const std::string& Password) throw(TKdbcException);
};



class TKdbcConnection_PostgreSQL: public TKdbcConnection {
  public:
    TKdbcConnection_PostgreSQL(PGconn* PgConnection);
    virtual ~TKdbcConnection_PostgreSQL();
    virtual void Disconnect(void);
    virtual TKdbcResult* ExecuteSql(const std::string& Statement) throw(TKdbcException);
  protected:
    PGconn* _PgConnection;
};



class TKdbcResult_PostgreSQL: public TKdbcResult {
  public:
    TKdbcResult_PostgreSQL(PGresult* PgResult);
    virtual ~TKdbcResult_PostgreSQL();
    virtual void Destroy(void);
    virtual std::string FieldNameOf(long Column) throw(TKdbcException);
    virtual std::string GetValueOf(long Raw, long Column) throw(TKdbcException);
    virtual std::string GetValueOf(long Raw, const std::string& FieldName) throw(TKdbcException);
  protected:
    PGresult* _PgResult;
};


#endif
