/* KiscScript.cc */
/* Created by Enomoto Sanshiro on 1 June 2001 */
/* Last updated by Enomoto Sanshiro on 7 December 2001. */


#include "ParaParser.hh"
#include "KiscSystemScript.hh"
#include "KiscDatabaseScript.hh"
#include "KiscScript.hh"

using namespace std;


TKiscScript::TKiscScript(void)
{
    _SystemScript = 0;
    _DatabaseScript = 0;
}

TKiscScript::TKiscScript(int argc, char** argv, TMushConsole* Console)
: TParaStandardParser(argc, argv)
{
    _SystemScript = 0;
    _DatabaseScript = 0;

    _Console = Console;
}

TKiscScript::~TKiscScript()
{
    delete _DatabaseScript;
    delete _SystemScript;
}

void TKiscScript::OnConstruct(void)
{
    TParaStandardParser::OnConstruct();

    Merge(_SystemScript = new TKiscSystemScript(_Console));
    Merge(_DatabaseScript = new TKiscDatabaseScript());
}
