/* KiscSystemScript.hh */
/* Created by Enomoto Sanshiro on 4 July 2001. */
/* Last updated by Enomoto Sanshiro on 4 July 2001. */


#ifndef __KiscSystemScript_hh_
#define __KiscSystemScript_hh_


#include "MushRegularExpression.hh"
#include "MushConsole.hh"
#include "ParaParser.hh"


class TKiscSystemScript: public TParaParser {
  public:
    TKiscSystemScript(TMushConsole* Console = 0);
    virtual ~TKiscSystemScript();
  protected:
    virtual TParaTokenTable* CreateTokenTable(void);
    virtual TParaOperatorTable* CreateOperatorTable(void);
    virtual TParaBuiltinFunctionTable* CreateBuiltinFunctionTable(void);
    virtual TParaObjectPrototypeTable* CreateObjectPrototypeTable(void);
  protected:
    TMushConsole* _Console;
    TMushConsole* _MyConsole;
};


class TKiscOperatorBitGenerate: public TParaOperator {
  public:
    virtual TParaOperator* Clone(void) const;
    virtual std::string Symbol(void) const;
    virtual std::string Name(void) const;
    virtual TParaValue& Evaluate(TParaValue& Left, TParaValue& Right, TParaSymbolTable* SymbolTable, TParaValue& Result) throw(TScriptException); 
};


class TKiscOperatorBitFill: public TParaOperator {
  public:
    virtual TParaOperator* Clone(void) const;
    virtual std::string Symbol(void) const;
    virtual std::string Name(void) const;
    virtual TParaValue& Evaluate(TParaValue& Left, TParaValue& Right, TParaSymbolTable* SymbolTable, TParaValue& Result) throw(TScriptException); 
};


class TKiscSystemObject: public TParaObjectPrototype {
  public:
    TKiscSystemObject(TMushConsole * Console);
    virtual ~TKiscSystemObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    TParaValue ReadLine(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue ExecuteProcess(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue WaitProcess(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue CurrentDirectory(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue MakeDirectory(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue ChangeDirectory(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue Sleep(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue Time(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue LocalTime(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue LocalTimeOf(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  protected:
    enum {
	MethodId_ReadLine = TParaObjectPrototype::_NumberOfMethods,
	MethodId_ExecuteProcess,
	MethodId_WaitProcess,
	MethodId_CurrentDirectory,
	MethodId_MakeDirectory,
	MethodId_ChangeDirectory,
	MethodId_Sleep,
	MethodId_Time,
	MethodId_LocalTime,
	MethodId_LocalTimeOf,
	_NumberOfMethods
    };
  protected:
    TMushConsole* _Console;
};


class TKiscEnvironmentVariableObject: public TParaObjectPrototype {
  public:
    TKiscEnvironmentVariableObject(void);
    virtual ~TKiscEnvironmentVariableObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    TParaValue Get(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue Set(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  protected:
    enum {
	MethodId_Get = TParaObjectPrototype::_NumberOfMethods,
	MethodId_Set,
	_NumberOfMethods
    };
};


class TKiscRegularExpressionObject: public TParaObjectPrototype {
  public:
    TKiscRegularExpressionObject(void);
    virtual ~TKiscRegularExpressionObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual void Destruct(void) throw(TScriptException);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    TParaValue Match(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue Substitute(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    TParaValue SubstituteAll(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  protected:
    enum {
	MethodId_Match = TParaObjectPrototype::_NumberOfMethods,
	MethodId_Substitute,
	MethodId_SubstituteAll,
	_NumberOfMethods
    };
  protected:
    TMushRegularExpression* _RegularExpression;
    std::string _Substitution;
};


class TKiscRegularExpressionLiteral {
  public:
    TKiscRegularExpressionLiteral(void);
    virtual ~TKiscRegularExpressionLiteral();
    virtual void Parse(TParaTokenizer* Tokenizer) throw(TScriptException);
    virtual const std::string& Pattern(void) const;
    virtual const std::string& Substitution(void) const;
    virtual int Operator(void) const;
    virtual int Modifier(void) const;
    virtual bool IsMatch(void) const;
    virtual bool IsSubstitution(void) const;
    virtual bool IsGlobal(void) const;
    virtual bool IsCaseInsensitive(void) const;
  protected:
    virtual void ProcessEscape(char& Character);
    virtual std::string ParsePattern(TParaTokenizer* Tokenizer) throw(TScriptException);
    virtual std::string ParseSubstitution(TParaTokenizer* Tokenizer) throw(TScriptException);
  public:
    enum TOperator { 
	Operator_Match, 
	Operator_Substitute,
    };
    enum TModifier { 
	Modifier_Global = 0x0001,
	Modifier_CaseInsensitive = 0x0002,
	Modifier_MultipleLine = 0x0004,
	Modifier_SingleLine = 0x0008,
    };
  protected:
    std::string _Pattern;
    std::string _Substitution;
    int _Operator;
    int _Modifier;
};


class TKiscOperatorRegularExpression: public TParaOperator {
  public:
    TKiscOperatorRegularExpression(void);
    virtual ~TKiscOperatorRegularExpression();
    virtual TParaOperator* Clone(void) const;
    virtual std::string Symbol(void) const;
    virtual std::string Name(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaExpressionParser* ExpressionParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TParaValue& Evaluate(TParaValue& Left, TParaValue& Right, TParaSymbolTable* SymbolTable, TParaValue& Result) throw(TScriptException); 
  protected:
    TMushRegularExpression* _RegularExpression;
    TKiscRegularExpressionLiteral* _Literal;
};



class TKiscOperatorSplit: public TParaOperator {
  public:
    TKiscOperatorSplit(void);
    virtual ~TKiscOperatorSplit();
    virtual TParaOperator* Clone(void) const;
    virtual std::string Symbol(void) const;
    virtual std::string Name(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaExpressionParser* ExpressionParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TParaValue& Evaluate(TParaValue& Left, TParaValue& Right, TParaSymbolTable* SymbolTable, TParaValue& Result) throw(TScriptException); 
  protected:
    TParaExpression* _TextExpression;
    std::string _Pattern;
    TMushRegularExpression* _RegularExpression;
};


#endif
