/* kisc-script.cc */
/* Created by Enomoto Sanshiro on 4 December 2001. */
/* Last updated by Enomoto Sanshiro on 4 December 2001. */


#include <iostream>
#include <fstream>
#include <cstdlib>
#include "KiscScript.hh"

using namespace std;


int main(int argc, char** argv)
{
    istream* InputStream;
    ifstream* SourceFileStream = 0;

    if (argc < 2) {
	InputStream = &cin;
    }
    else {
	SourceFileStream = new ifstream(argv[1]);
	if (! *SourceFileStream) {
	    cerr << "ERROR: unable to open " << argv[1] << endl;
	    return 0;
	}
	InputStream = SourceFileStream;
    }

    TKiscScript* Script = new TKiscScript(argc - 1, argv + 1);

    try {
        Script->Parse(*InputStream);
    }
    catch (TScriptException &e) {
	cerr << "ERROR: " << e << endl;
	return EXIT_FAILURE;
    }

    TParaValue Result;
    try {
	if (Script->HasEntryOf("main")) {
	    Result = Script->Execute("main");
	}
	else {
	    Result = Script->Execute();
	}
    }
    catch (TScriptException &e) {
        cerr << "ERROR: " << e << endl;
    }

    delete Script;
    delete SourceFileStream;
    
    return Result.AsLong();
}
