/* KmlcDataElement.hh */
/* Created by Enomoto Sanshiro on 21 January 2001 */
/* Last updated by Enomoto Sanshiro on 21 January 2001. */


#ifndef __KmlcDataElement_hh__
#define __KmlcDataElement_hh__


#include <complex>
#include "KmlcDefs.hh"


template<class T = double> class TKmlcBase2dDataElement {
  public:
    inline TKmlcBase2dDataElement(void);
    inline TKmlcBase2dDataElement(const T& XValue, const T& YValue, const T& XError = 0, const T& YError = 0);
    inline TKmlcBase2dDataElement(const TKmlcBase2dDataElement<T>& DataElement);
    inline ~TKmlcBase2dDataElement();
    inline TKmlcBase2dDataElement<T>& operator= (const TKmlcBase2dDataElement<T>& DataElement);
    inline void SetData(const T& XValue, const T& YValue, const T& XError = 0, const T& YError = 0);
    inline const T& X(void) const;
    inline const T& Y(void) const;
    inline const T& XError(void) const;
    inline const T& YError(void) const;
  protected:
    T _XValue, _XError;
    T _YValue, _YError;
};


typedef TKmlcBase2dDataElement<double> TKmlc2dDataElement;
typedef TKmlcBase2dDataElement<std::complex<double> > TKmlcComplex2dDataElement;



template<class T> inline TKmlcBase2dDataElement<T>::TKmlcBase2dDataElement(void)
{
    _XValue = 0;
    _XError = 0;
    _YValue = 0;
    _YError = 0;
}

template<class T> inline TKmlcBase2dDataElement<T>::TKmlcBase2dDataElement(const T& XValue, const T& YValue, const T& XError, const T& YError)
{
    _XValue = XValue;
    _XError = XError;
    _YValue = YValue;
    _YError = YError;
}

template<class T> inline TKmlcBase2dDataElement<T>::TKmlcBase2dDataElement(const TKmlcBase2dDataElement<T>& DataElement)
{
    _XValue = DataElement._XValue;
    _XError = DataElement._XError;
    _YValue = DataElement._YValue;
    _YError = DataElement._YError;
}

template<class T> inline TKmlcBase2dDataElement<T>::~TKmlcBase2dDataElement()
{
}

template<class T> inline TKmlcBase2dDataElement<T>& TKmlcBase2dDataElement<T>::operator= (const TKmlcBase2dDataElement<T>& DataElement)
{
    _XValue = DataElement._XValue;
    _XError = DataElement._XError;
    _YValue = DataElement._YValue;
    _YError = DataElement._YError;

    return *this;
}

template<class T> inline void TKmlcBase2dDataElement<T>::SetData(const T& XValue, const T& YValue, const T& XError, const T& YError)
{
    _XValue = XValue;
    _XError = XError;
    _YValue = YValue;
    _YError = YError;
}

template<class T> inline const T& TKmlcBase2dDataElement<T>::X(void) const
{
    return _XValue;
}

template<class T> inline const T& TKmlcBase2dDataElement<T>::Y(void) const
{
    return _YValue;
}

template<class T> inline const T& TKmlcBase2dDataElement<T>::XError(void) const
{
    return _XError;
}

template<class T> inline const T& TKmlcBase2dDataElement<T>::YError(void) const
{
    return _YError;
}


#endif
