/* KmlcFunction.hh */
/* Created by Enomoto Sanshiro on 18 January 2001. */
/* Last updated by Enomoto Sanshiro on 26 May 2002. */


#ifndef __KmlcFunction_hh__
#define __KmlcFunction_hh__


#include <complex>
#include "KmlcDefs.hh"
#include "KmlcVector.hh"
#include "KmlcPrimitive.hh"


template<class T = double> class TKmlcFunctionBase {
  public:
    TKmlcFunctionBase(void) {}
    virtual ~TKmlcFunctionBase() {}
    virtual T ValueOf(const T* InputValueList, int InputListSize) = 0;
    inline T operator() (const T& InputValue) { 
	return ValueOf(&InputValue, 1); 
    }
};


typedef TKmlcFunctionBase<double> TKmlcFunction;
typedef TKmlcFunctionBase<std::complex<double> > TKmlcComplexFunction;


template<class T = double> class TKmlcParameterizedFunctionBase: public TKmlcFunctionBase<T> {
  public:
    TKmlcParameterizedFunctionBase(void) {}
    virtual ~TKmlcParameterizedFunctionBase(void) {}
    virtual TKmlcVectorBase<TKmlcPrimitiveBase<T> >& ParameterList(void) {
	return _ParameterList;
    }
    inline TKmlcPrimitiveBase<T>& operator[] (int PatameterIndex) {
	return _ParameterList[PatameterIndex];
    }
  protected:
    TKmlcVectorBase<TKmlcPrimitiveBase<T> > _ParameterList;
};


typedef TKmlcParameterizedFunctionBase<double> TKmlcParameterizedFunction;
typedef TKmlcParameterizedFunctionBase<std::complex<double> > TKmlcComplexParameterizedFunction;


template<class T = double> class TKmlcPolynominalFunctionBase: public TKmlcParameterizedFunctionBase<T> {
  public:
    TKmlcPolynominalFunctionBase(int MaxOrder) {
	_MaxOrder = MaxOrder;
	for (int i = 0; i <= _MaxOrder; i++) {
	    _ParameterList.Add(TKmlcPrimitiveBase<T>(0));
	}
    }

    TKmlcPolynominalFunctionBase(const TKmlcVectorBase<TKmlcPrimitiveBase<T> >& CoefficientList) {
	_MaxOrder = CoefficientList.size() - 1;
	_ParameterList = CoefficientList;
    }

    virtual ~TKmlcPolynominalFunctionBase() {
    }

    virtual int MaxOrder(void) const {
	return _MaxOrder;
    }

    virtual T ValueOf(const T* InputValueList, int InputListSize) {
	T Term = 1;
	T Result = 0;
	//... the following caluclation should be improved
	for (int i = 0; i <= _MaxOrder; i++) {
	    Result += _ParameterList[i] * Term;
	    Term *= InputValueList[0];
	}
	return Result;
    }

  protected:
    int _MaxOrder;
};

typedef TKmlcPolynominalFunctionBase<double> TKmlcPolynominalFunction;
typedef TKmlcPolynominalFunctionBase<std::complex<double> > TKmlcComplexPolynominalFunction;


#endif
