/* KmlcFunctionFitter.cc */
/* Created by Enomoto Sanshiro on 21 January 2001 */
/* Last updated by Enomoto Sanshiro on 26 May 2002. */


#include <complex>
#include <cfloat>
#include "KmlcVector.hh"
#include "KmlcPrimitive.hh"
#include "KmlcFunction.hh"
#include "KmlcFunctionFitter.hh"

using namespace std;


TKmlcChiSquaredFunction::TKmlcChiSquaredFunction(TKmlcParameterizedFunction& Function, TKmlcPrimitiveVector& XDataList, TKmlcPrimitiveVector& YDataList)
: _Function(Function), _XDataList(XDataList), _YDataList(YDataList)
{
}

TKmlcChiSquaredFunction::~TKmlcChiSquaredFunction(void)
{
}

double TKmlcChiSquaredFunction::ValueOf(const double* InputValueList, int InputListSize)
{
    if (_Function.ParameterList().Size() != InputListSize) {
	throw TKmlcException(
	    " TKmlcChiSquaredFunction::ValueOf()",
	    "inconsistent number of parameters"
	);
    }

    for (int i = 0; i < InputListSize; i++) {
	_Function[i] = InputValueList[i];
    }

    double ChiSquared = 0;
    for (int i = 0; i < _XDataList.Size(); i++) {
	double X = _XDataList[i].Value();
	double Y = _YDataList[i].Value();
	double Variance = _YDataList[i].Variance();

	try {
	    double Distance = Y - _Function(X);
	    ChiSquared += Distance * Distance / Variance;
	}
	catch (TKmlcException &e) {
	    ChiSquared = FLT_MAX;
	    break;
	}
    }

    return ChiSquared;
}



TKmlcFunctionFitter::TKmlcFunctionFitter(TKmlcFunctionMinimizer* Minimizer)
: _Minimizer(Minimizer)
{    
}

TKmlcFunctionFitter::~TKmlcFunctionFitter(void)
{
}

double TKmlcFunctionFitter::Fit(TKmlcParameterizedFunction& Function, TKmlcPrimitiveVector& XDataList, TKmlcPrimitiveVector& YDataList) throw(TKmlcException)
{
    TKmlcChiSquaredFunction ChiSquaredFunction(Function, XDataList, YDataList);
    TKmlcPrimitiveVector& ParameterList = Function.ParameterList();

    double ChiSquared = _Minimizer->Minimize(ChiSquaredFunction, ParameterList);

    return ChiSquared;
}
