/* KmlcFunctionFitter.hh */
/* Created by Enomoto Sanshiro on 18 January 2001 */
/* Last updated by Enomoto Sanshiro on 26 May 2002. */


#ifndef __KmlcFunctionFitter_hh__
#define __KmlcFunctionFitter_hh__


#include "KmlcVector.hh"
#include "KmlcPrimitive.hh"
#include "KmlcFunction.hh"
#include "KmlcFunctionMinimizer.hh"



class TKmlcChiSquaredFunction: public TKmlcFunction {
  public:
    TKmlcChiSquaredFunction(TKmlcParameterizedFunction& Function, TKmlcPrimitiveVector& XDataList, TKmlcPrimitiveVector& YDataList);
    virtual ~TKmlcChiSquaredFunction(void);
    virtual double ValueOf(const double* InputValueList, int InputListSize);
  protected:
    TKmlcParameterizedFunction& _Function;
    TKmlcPrimitiveVector& _XDataList;
    TKmlcPrimitiveVector& _YDataList;
};


class TKmlcFunctionFitter {
  public:
    TKmlcFunctionFitter(TKmlcFunctionMinimizer* Minimizer);
    virtual ~TKmlcFunctionFitter(void);
    virtual double Fit(TKmlcParameterizedFunction& Function, TKmlcPrimitiveVector& XDataList, TKmlcPrimitiveVector& YDataList) throw(TKmlcException);
  protected:
    TKmlcFunctionMinimizer* _Minimizer;
};


#endif
