/* KmlcFunctionInterpolator.hh */
/* Created by Enomoto Sanshiro on 13 February 2003. */
/* Last updated by Enomoto Sanshiro on 13 February 2003. */


#ifndef __KmlcFunctionInterpolator_hh__
#define __KmlcFunctionInterpolator_hh__


#include "KmlcFunction.hh"


template<class T = double> class TKmlcInterpolatedFunctionBase: public TKmlcFunctionBase<T> {
  public:
    TKmlcInterpolatedFunctionBase(void) {}
    virtual ~TKmlcInterpolatedFunctionBase(void) {}
    virtual void ReadData(const T* XValueList, const T* YValueList, int ListSize) throw(TKmlcException) = 0;
  protected:
};


typedef TKmlcInterpolatedFunctionBase<double> TKmlcInterpolatedFunction;
typedef TKmlcInterpolatedFunctionBase<std::complex<double> > TKmlcComplexInterpolatedFunction;



template<class T = double> class TKmlcLinearInterpolatedFunctionBase: public TKmlcInterpolatedFunctionBase<T> {
  public:
    TKmlcLinearInterpolatedFunctionBase(void) {
	_XValueList = 0;
	_YValueList = 0;
	_ListSize = 0;
	_Index = 0;
    }

    virtual ~TKmlcLinearInterpolatedFunctionBase() {
	delete[] _XValueList;
	delete[] _YValueList;
    }

    virtual T ValueOf(const T* InputValueList, int InputListSize) {
	const T& X = InputValueList[0];
	while (_XValueList[_Index + 1] < X) {
	    if (_Index + 1 == _ListSize - 1) {
		break;
	    }
	    _Index++;
	}
	while (_XValueList[_Index] > X) {
	    if (_Index == 0) {
		break;
	    }
	    _Index--;
	}

	const T& LeftX = _XValueList[_Index];
	const T& RightX = _XValueList[_Index + 1];
	T Ratio = (X - LeftX) / (RightX - LeftX);

	const T& LeftY = _YValueList[_Index];
	const T& RightY = _YValueList[_Index + 1];
	return (1.0 - Ratio) * LeftY + Ratio * RightY;
    }

    virtual void ReadData(const T* XValueList, const T* YValueList, int ListSize) throw (TKmlcException) {
	if (ListSize > _ListSize) {
	    delete[] _XValueList;
	    delete[] _YValueList;
	    _XValueList = new T[ListSize];
	    _YValueList = new T[ListSize];
	}
	_ListSize = ListSize;

	T LastX = XValueList[0] - 1;
	for (int i = 0; i < _ListSize; i++) {
	    if (XValueList[i] < LastX) {
		throw TKmlcException(
		    "TLinearInterpolatedFunction::ReadData()",
		    "data list is out of order"
		);
	    }
	    LastX = XValueList[i];

	    _XValueList[i] = XValueList[i];
	    _YValueList[i] = YValueList[i];
	}
    }

  protected:
    T* _XValueList;
    T* _YValueList;
    int _ListSize;
    mutable int _Index;
};

typedef TKmlcLinearInterpolatedFunctionBase<double> TKmlcLinearInterpolatedFunction;
typedef TKmlcLinearInterpolatedFunctionBase<std::complex<double> > TKmlcComplexLinearInterpolatedFunction;


#endif
