/* KmlcManager.cc */
/* Created by Enomoto Sanshiro on 2 June 2002. */
/* Last updated by Enomoto Sanshiro on 2 June 2002. */


#include <string>
#include <map>
#include "KmlcDefs.hh"
#include "KmlcFunctionMinimizer.hh"
#include "KmlcManager.hh"

using namespace std;


TKmlcManager* TKmlcManager::_Instance = 0;

TKmlcManager::TKmlcManager(void)
{
}

TKmlcManager::~TKmlcManager()
{
}

TKmlcManager* TKmlcManager::GetInstance(void)
{
    if (_Instance == 0) {
        _Instance = new TKmlcManager();
    }

    return _Instance;
}

void TKmlcManager::RegisterFunctionMinimizer(const string& Name, TKmlcFunctionMinimizer* FunctionMinimizer)
{
    _FunctionMinimizerTable[Name] = FunctionMinimizer;
}

TKmlcFunctionMinimizer* TKmlcManager::CreateFunctionMinimizer(const string& Name) throw(TKmlcException)
{
    if (Name.empty()) {
	if (_FunctionMinimizerTable.empty()) {
	    throw TKmlcException(
		"TKmlcManager::CreateFunctionMinimizer()", 
		"no function minimizer is available"
	    );
	}
	return (*_FunctionMinimizerTable.begin()).second->Clone();
    }

    if (_FunctionMinimizerTable.count(Name) == 0) {
	throw TKmlcException(
	    "TKmlcManager::CreateFunctionMinimizer()", 
	    "unknown function minimizer: " + Name
	);
    }

    return _FunctionMinimizerTable[Name]->Clone();
}

void TKmlcManager::ShowFunctionMinimizerList(std::ostream& os) const
{
    cout << "Function Minimizers:" << endl;
    map<string, TKmlcFunctionMinimizer*>::const_iterator FunctionMinimizer;
    for (
	 FunctionMinimizer = _FunctionMinimizerTable.begin();
	 FunctionMinimizer != _FunctionMinimizerTable.end();
	 FunctionMinimizer++
    ){
        os << "    " << FunctionMinimizer->first << endl;
    }
    os << endl;
}



TKmlcFunctionMinimizerCreator::TKmlcFunctionMinimizerCreator(const string& Name, TKmlcFunctionMinimizer* FunctionMinimizer)
{
    TKmlcManager::GetInstance()->RegisterFunctionMinimizer(Name, FunctionMinimizer);
}
