/* KmlcVector.hh */
/* Created by Enomoto Sanshiro on 18 January 2001 */
/* Last updated by Enomoto Sanshiro on 18 January 2001. */


#ifndef __KmlcVector_hh__
#define __KmlcVector_hh__


#include <complex>


template<class T = double> class TKmlcVectorBase {
  public:
    inline TKmlcVectorBase(int Size = 0, int InitialCapacity = 32);
    inline TKmlcVectorBase(const TKmlcVectorBase<T>& Vector);
    inline ~TKmlcVectorBase();
    inline TKmlcVectorBase<T>& operator= (const TKmlcVectorBase<T>& Vector);
    inline int Add(const T& Value);
    inline int Size(void) const;
    inline const T& operator[] (int Index) const;
    inline T& operator[] (int Index);
    inline T* RawArray(void);
    inline const T* RawArray(void) const;
  protected:
    int _Capacity;
    int _Size;
    T* _RawArray;
};


typedef TKmlcVectorBase<double> TKmlcVector;
typedef TKmlcVectorBase<std::complex<double> > TKmlcComplexVector;


template<class T> inline TKmlcVectorBase<T>::TKmlcVectorBase(int Size, int InitialCapacity)
{
    _Size = Size;
    _Capacity = InitialCapacity;
    if (_Size > _Capacity) {
	_Capacity = _Size;
    }

    _RawArray = new T[_Capacity];
}

template<class T> inline TKmlcVectorBase<T>::TKmlcVectorBase(const TKmlcVectorBase<T>& Vector)
{
    _Capacity = Vector._Size;
    _Size = Vector._Size;
    _RawArray = new T[_Capacity];

    for (unsigned i = 0; i < _Size; i++) {
	_RawArray[i] = Vector._RawArray[i];
    }
}

template<class T> inline TKmlcVectorBase<T>::~TKmlcVectorBase()
{
    delete[] _RawArray;
}

template<class T> inline TKmlcVectorBase<T>& TKmlcVectorBase<T>::operator= (const TKmlcVectorBase<T>& Vector)
{
    if (_Capacity < Vector._Size) {
	delete [] _RawArray;
	_Capacity = Vector._Size;
	_RawArray = new T[_Capacity];
    }
    _Size = Vector._Size;

    for (int i = 0; i < _Size; i++) {
	_RawArray[i] = Vector._RawArray[i];
    }

    return *this;
}

template<class T> inline int TKmlcVectorBase<T>::Add(const T& Value)
{
    if (_Size + 1 > _Capacity) {
	T* OldArray = _RawArray;
	_Capacity *= 2;
	_RawArray = new T[_Capacity];
	for (int i = 0; i < _Size; i++) {
	    _RawArray[i] = OldArray[i];
	}
	delete[] OldArray;
    }

    _RawArray[_Size++] = Value;

    return _Size - 1;
}

template<class T> inline int TKmlcVectorBase<T>::Size(void) const
{
    return _Size;
}

template<class T> inline T& TKmlcVectorBase<T>::operator[] (int Index)
{
    return _RawArray[Index];
}

template<class T> inline const T& TKmlcVectorBase<T>::operator[] (int Index) const
{
    return _RawArray[Index];
}

template<class T> inline T* TKmlcVectorBase<T>::RawArray(void)
{
    return _RawArray;
}

template<class T> inline const T* TKmlcVectorBase<T>::RawArray(void) const
{
    return _RawArray;
}


#endif
