/* math-Gemini.cc */
/* Created by Enomoto Sanshiro on 25 May 2002 */
/* Last updated by Enomoto Sanshiro on 2 June 2002. */


#include "KmlcManager.hh"
#include "KmlcPrimitive.hh"
#include "KmlcFunction.hh"
#include "KmlcFunctionMinimizer.hh"
#include "math-Gemini.hh"
#include <Gemini/gemini.h>

using namespace std;


static TKmlcFunctionMinimizerCreator Creator1(
    "Gemini", new TKmlcFunctionMinimizer_Gemini()
);


class TKmlcGeminiFunction: public OBJfun {
  public:
    TKmlcGeminiFunction(TKmlcFunction& Function);
    virtual ~TKmlcGeminiFunction();
    virtual void objfun(int n, double grad[], double* val, const double x[], int code);
  protected:
    TKmlcFunction& _Function;
};



TKmlcGeminiFunction::TKmlcGeminiFunction(TKmlcFunction& Function)
: _Function(Function)
{
}

TKmlcGeminiFunction::~TKmlcGeminiFunction()
{
}

void TKmlcGeminiFunction::objfun(int n, double grad[], double* val, const double x[], int code)
{
    *val = _Function.ValueOf(x, n);
}



TKmlcFunctionMinimizer_Gemini::TKmlcFunctionMinimizer_Gemini(void)
{
}

TKmlcFunctionMinimizer_Gemini::~TKmlcFunctionMinimizer_Gemini(void)
{
}

TKmlcFunctionMinimizer* TKmlcFunctionMinimizer_Gemini::Clone(void)
{
    return new TKmlcFunctionMinimizer_Gemini();
}

double TKmlcFunctionMinimizer_Gemini::Minimize(TKmlcFunction& Function, TKmlcPrimitiveVector& ValueList) throw(TKmlcException)
{
    TKmlcGeminiFunction GeminiFunction(Function);

    GEmini* Gemini = new CMinuit();

    //Gemini->setPrintLevel(-1);
    //Gemini->warningsOFF();

    Gemini->setTitle("chi2");
    Gemini->setObjFun(ValueList.Size(), &GeminiFunction);
    Gemini->setError(1.0);  // 1 for chi2 fit
    Gemini->resetStartPoint();

    double Step = 1.0;
    double LowerBound = MINF;
    double UpperBound = INF;
    for (int Index = 0; Index < ValueList.Size(); Index++) {
	Gemini->parmDef(
	    Index + 1, 
	    ValueList[Index].Name().c_str(), 
	    ValueList[Index].Value(), Step, 
	    LowerBound, UpperBound
	);
    }

    Gemini->minimize();
    Gemini->printResults();

    double Value, Error, FunctionValue;
    for (int Index = 0; Index < ValueList.Size(); Index++) {
	Gemini->getResult(Index + 1, Value, Error, FunctionValue);
	ValueList[Index].Value() = Value;
	ValueList[Index].Error() = Error;
    }

    delete Gemini;

    return FunctionValue;
}
